var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('Dao');

var DownloadSourcecodePre = function () {
    Service.call(this);
    this.checkLogin = false;
};

util.inherits(DownloadSourcecodePre, Service);

module.exports = DownloadSourcecodePre;

/**
 * 下载源码
 * @param   {Object} req 服务请求对象
 * @param   {String} req.appCode 应用编码
 * @param   {String} req.systemCode 系统编码
 */
DownloadSourcecodePre.prototype.process = async function (req, res) {
    this.pipe(server.loadModule('/app/dev/service/product/getProduct'), req, { code: 0 }, (req0, res0) => {
        console.log(res0.packageConfig);
        if (res0.packageConfig.sourcecodeVersion == res0.data.sourcecode_version) {
            return this.onLogicError(1, '源码已是最新版，无需更新！');
        }

        this.pipe(server.loadModule('/app/dev/service/product/downloadSourcecode'), req, { code: 0 }, (req1, res1) => {
            this.end(res1);
        });
    });
};