var util = require('util');
var Service = require('Service');

/**
 * 开发者登录
 */
var DevLogin = function () {
  Service.call(this);
};

util.inherits(DevLogin, Service);

module.exports = DevLogin;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DevLogin.prototype.process = function (req, res) {
  var self = this;
  if (!req.uname) {
    self.onLogicError(1, '请提供登录名！');
    return;
  }
  if (!req.upwd) {
    self.onLogicError(2, '请提供登录密码！');
    return;
  }
  if (!req.systemCode) {
    this.onLogicError(2, '请提供组织代码！');
    return;
  }

  //向运营服务器发送请求
  self.sendHttpRequest({
    "urlPath": "http://market.taskmsg.com:8001/Service", //"http://market.taskmsg.com/Service",
    "method": "post",
    "retToJson": true,
    "headers": {
      "Content-Type": "application/json"
    },
    "postdata": {
        "service": "om/service/tpm/login", //"om/service/createApp",
        "uname": req.uname,
        "upwd": req.upwd,
        "systemCode": req.systemCode
    }
  },
  function(reqHttp, resHttp, errHttp, retHttp) {
    res.data = retHttp;
    self.end(res);
  });
};