var util = require('util');
var path = require('path');
var fs = require('fs');
var Service = require('Service');
var utils = require('./utilExt');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 添加项目
 */
var AddProduct = function () {
  Service.call(this);
  this.packageJsonString = "";
};

util.inherits(AddProduct, Service);

module.exports = AddProduct;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AddProduct.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(6, "请先登录开发者账号！");
    return;
  }
  if (!req.systemCode) {
    this.onLogicError(0, "请提供系统代码！");
    return;
  }
  if (!req.packageCode) {
    this.onLogicError(1, "请提供产品代码！");
    return;
  }
  if (req.packageCode.match(/[^\w]/g)) {
    this.onLogicError(2, "产品代码只能包含字母、数字或下划线！");
    return;
  }
  if (!req.packageName) {
    this.onLogicError(3, "请提供产品名称！");
    return;
  }
  if (!req.version) {
    this.onLogicError(4, "请提供产品版本！");
    return;
  }

  //连接任讯应用市场服务器，创建应用
  this.createAppPackage(req, res);
};

//用HTTP请求连接运营服务器，判断该组织是否已存在同名或相同code的产品
AddProduct.prototype.createAppPackage = function (req, res) {
  var self = this;
  var msg = {
    "service": "dp/service/tpm/createPackage",
    "packageCode": req.packageCode,
    "packageName": req.packageName,
    "version": req.version,
    "systemCode": req.systemCode,
    "userId": req.userId
  };

  //向运营服务器发送请求
  requestMarket(this, msg, function (retHttp) {
    res.om_ret = retHttp;
    if (retHttp.code != 0) {
      self.onLogicError(6, retHttp.message);
      return;
    }

    if (retHttp.code == 0) {
      let obj = {};
      obj.id = retHttp.appInfo.id;
      obj.code = req.packageCode;
      obj.name = req.packageName;
      obj.system = {
        'id': retHttp.sysId,
        'code': retHttp.sysCode,
        'name': retHttp.sysName
      };
      obj.version = req.version;      
      self.packageJsonString = JSON.stringify(obj, null, "\t");

      //创建包开发目录 /app/组织code/packageCode
      self.createDir(req, retHttp.sysCode);

      //创建包临时目录,用于发布时存放复制过来的文件
      let tmpFilePath = utils.getPath('/tpm/package/' + retHttp.sysCode + '/publish/' + req.packageCode);
      //创建多级目录
      if (utils.mkdirsSync(tmpFilePath)) {
        utils.mkdirsSync(tmpFilePath + '/app');
        utils.mkdirsSync(tmpFilePath + '/web');
        utils.mkdirsSync(tmpFilePath + '/db');
        //utils.mkdirsSync(tmpFilePath + '/minisrc');
        //创建package.json
        var fd = 0;
        try {
          fd = fs.openSync(tmpFilePath + '/app.json', 'w');
          fs.writeSync(fd, self.packageJsonString);
          fs.closeSync(fd);
          self.end(res);
        } catch (e) {
          if (fd != 0) {
            fs.closeSync(fd);
          }
          return;
        }
      }
    }
  });
};

AddProduct.prototype.createDir = function (req, sysCode) {
  var self = this;
  //创建当前组织的后台服务目录
  var orgDir = utils.getPath("/app/" + sysCode);
  //判断后台服务目录有没有当前组织的目 录，如果没有，则创建
  if (!fs.existsSync(orgDir)) fs.mkdirSync(orgDir);
  var productDir = orgDir + "/" + req.packageCode;
  //判断后台服务目录的当前组织目录中是否已经存在相同code的目录，如果已经存在，则退出
  if (fs.existsSync(productDir)) {
    this.onLogicError(11, "产品目录[" + req.packageCode + "]已存在！");
    return;
  }
  fs.mkdirSync(productDir);

  //创建产品开发目录的包文件, 与临时上传目录中的相同
  var configFile = productDir + "/app.json";
  fs.writeFileSync(configFile, self.packageJsonString);

  //创建数据模型目录
  var modelDir = productDir + "/model";
  if (!fs.existsSync(modelDir)) fs.mkdirSync(modelDir);

  //创建业务服务目录
  var serviceDir = productDir + "/service";
  if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);

  //创建数据库目录
  var dbDir = productDir + "/db";
  if (!fs.existsSync(dbDir)) fs.mkdirSync(dbDir);

  //创建前端web目录
  var webOrgDir = utils.getPath("/web/app/" + sysCode);
  if (!fs.existsSync(webOrgDir)) fs.mkdirSync(webOrgDir);
  var webDir = webOrgDir + "/" + req.packageCode;
  if (!fs.existsSync(webDir)) fs.mkdirSync(webDir);

  //创建小程序目录
  // var miniDir = utils.getPath("/minisrc/" + req.packageCode);
  // if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  // var miniprogramDir = utils.getPath("/miniprogram/" + req.packageCode);
  // if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);
};