var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获取手机支付信息
 */
var Get = function () {
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process = function (req, res) {
  if (!req.projCode) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }
  if (!req.miniCode) {
    this.onLogicError(1, "请提供小程序编码！");
    return;
  }
  var self = this;
  res.projCode = req.projCode;
  res.miniCode = req.miniCode;
  self.getProjectSetting(req, res, function () {
    self.end(res);
  });
};

/**
 * 后台setting.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.getProjectSetting = function (req, res, cb) {
  var self = this;
  var projectConfigFile = utils.getPath("/app/" + req.miniCode + "/setting.json");
  fs.readFile(projectConfigFile, "utf-8", function (err, data) {
    if (data) {
      var dataobj = JSON.parse(data);
      res.pathArray = dataobj.wxpay.pathArray;
    }
    cb();
  });
};
