var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');
const { requestOperationSync } = server.loadModule('/app/dev/service/requestUtils');

var Register = function () {
    Service.call(this);
};

util.inherits(Register, Service);

module.exports = Register;

/**
 * 注册组织
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Register.prototype.process = async function (req, res) {
    const dao = new Dao(this);

    // 请求运营平台
    const registResult = await requestOperationSync(this, {
        ...req, service: 'dp/service/organize/regist'
    });
    if (registResult.code != 0) return this.onLogicError(registResult.code, '注册失败，错误描述：' + registResult.message);

    // 修改系统组织信息
    await dao.executeSync(
        'update sys_org set code=?,name=?,auth_key=?,status=0,createtime=?,last_update=? where id=1',
        [req.orgCode, req.orgName, registResult.authKey, new Date(), new Date()]
    );

    // 修改系统配置文件
    server.config.OrgCode = req.orgCode;
    server.config.MessagePush = {
        PushServer: {
            host: 'push.taskmsg.com',
            port: 7103,
            loginCode: req.orgCode,
            loginKey: registResult.authKey
        },
        msgIdFilePath: '/cache/msgId.json',
        enableAndPush: true
    };
    utils.saveJSONToFile(utils.getPath('/config/Tasgine.json'), server.config);

    this.end(res);
};
