var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

var Register = function () {
    Service.call(this);
};

util.inherits(Register, Service);

module.exports = Register;

/**
 * 登录OM账户后，将选择的组织写入系统中
 * @param  {object} req 服务请求对象
 * @param  {object} req.orgCode 组织代码
 * @param  {object} req.orgName 组织名称
 * @param  {object} req.authKey 秘钥
 * @param  {object} res 服务响应对象
 */
Register.prototype.process = async function (req, res) {
    const { orgCode, orgName, authKey } = req;

    const dao = new Dao(this);

    // 修改系统组织信息
    await dao.executeSync(
        'update sys_org set code=?,name=?,auth_key=?,status=0,createtime=?,last_update=? where id=1',
        [orgCode, orgName, authKey, new Date(), new Date()]
    );

    // 修改系统配置文件
    server.config.OrgCode = orgCode;
    server.config.MessagePush = {
        PushServer: {
            host: 'push.taskmsg.com',
            port: 7103,
            loginCode: orgCode,
            loginKey: authKey
        },
        msgIdFilePath: '/cache/msgId.json',
        enableAndPush: true
    };
    utils.saveJSONToFile(utils.getPath('/config/Tasgine.json'), server.config);

    this.end(res);
};
