const Service = require('Service');
const util = require('util');
const utils = require('utils');
const fs = require('fs');
const path = require('path');

const ReadFile = function () {
    Service.call(this);
};

util.inherits(ReadFile, Service);

module.exports = ReadFile;

/**
 * 获取文件内容
 * @param  {Object} req 服务请求对象
 * @param  {Object} req.filePath 文件路径
 * @param  {Object} res 服务响应对象
 */
ReadFile.prototype.process = function (req, res) {
    let filePath = req.filePath;
    filePath = path.join(process.cwd(), '/web/', filePath)
    const fileData = fs.readFileSync(filePath, 'utf8');
    res.fileData = fileData;
    this.end(res);
};