var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 设置小程序
 */
var Set = function () {
  Service.call(this);
};

util.inherits(Set, Service);

module.exports = Set;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Set.prototype.process = function (req, res) {
  //serverUrl projCode miniCode
  //projectname appid
  //backgroundTextStyle navigationBarBackgroundColor navigationBarTitleText navigationBarTextStyle
  if (!req.projCode) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }
  if (!req.miniCode) {
    this.onLogicError(1, "请提供小程序编码！");
    return;
  }
  var self = this;
  var miniDir0 = utils.getPath("/minisrc/" + req.projCode);
  if (!fs.existsSync(miniDir0)) fs.mkdirSync(miniDir0);
  var miniprogramDir0 = utils.getPath("/miniprogram/" + req.projCode);
  if (!fs.existsSync(miniprogramDir0)) fs.mkdirSync(miniprogramDir0);
  var miniDir = utils.getPath("/minisrc/" + req.projCode + "/" + req.miniCode);
  if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  var miniprogramDir = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode);
  if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);

  //前台config
  self.setMiniProjectConfig(req, function () {
    self.setMiniAppConfig(req, function () {
      self.setMiniUtilJs(req, function () {
        self.setMiniAppJs(req, function () {
          self.setProjectConfig(req, function () {
            self.end(res);
          });
        });
      });
    });
  });
};

/**
 * project.config.json
 * @param {*} req 
 * @param {*} cb 
 */
Set.prototype.setMiniProjectConfig = function (req, cb) {
  var self = this;
  var miniProjectConfigJson = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/project.config.json");
  fs.readFile(miniProjectConfigJson, "utf-8", function (err, data) {
    var data0 = JSON.parse(data);
    if (req.appid) data0.appid = req.appid;
    if (req.projectname) data0.projectname = req.projectname;
    if (req.version) data0.version = req.version;
    if (req.release) data0.release = req.release;
    fs.writeFile(miniProjectConfigJson, JSON.stringify(data0, null, 2), function (err) {
      cb();
    });
  });
};

/**
 * app.json
 * @param {*} req 
 * @param {*} cb 
 */
Set.prototype.setMiniAppConfig = function (req, cb) {
  var self = this;
  var miniAppConfigJson = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/app.json");
  fs.readFile(miniAppConfigJson, "utf-8", function (err, data) {
    var data0 = JSON.parse(data);
    if (req.backgroundTextStyle) data0.window.backgroundTextStyle = req.backgroundTextStyle;
    if (req.navigationBarBackgroundColor) data0.window.navigationBarBackgroundColor = req.navigationBarBackgroundColor;
    // if (req.navigationBarTitleText) data0.window.navigationBarTitleText = req.navigationBarTitleText;
    if (req.navigationBarTextStyle) data0.window.navigationBarTextStyle = req.navigationBarTextStyle;
    if (req.entryPagePath) data0.entryPagePath = req.entryPagePath;

    for (var i = 0; i < data0.pages.length; i++) {
      if (data0.pages[i] == data0.entryPagePath) {
        data0.pages.splice(i, 1);
        break;
      }
    }
    data0.pages.unshift(data0.entryPagePath);

    fs.writeFile(miniAppConfigJson, JSON.stringify(data0, null, 2), function (err) {
      cb();
    });
  });
};

/**
 * util.js
 * @param {*} req 
 * @param {*} cb 
 */
Set.prototype.setMiniUtilJs = function (req, cb) {
  if (!req.serverUrl) cb();
  var self = this;
  var miniUtilJs = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/utils/util.js");
  fs.readFile(miniUtilJs, "utf-8", function (err, data) {
    var data0 = "const serverUrl = '" + req.serverUrl + "';" + data.substring(data.indexOf('\n'));
    fs.writeFile(miniUtilJs, data0, function (err) {
      cb();
    });
  });
};

/**
 * app.js
 * @param {*} req 
 * @param {*} cb 
 */
Set.prototype.setMiniAppJs = function (req, cb) {
  var self = this;
  var miniAppJs = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/app.js");
  fs.readFile(miniAppJs, "utf-8", function (err, data) {
    var data0 = "const projInfo = { projCode: \"" + req.projCode + "\", miniCode: \"" + req.miniCode + "\" };" + data.substring(data.indexOf('\n'));
    fs.writeFile(miniAppJs, data0, function (err) {
      cb();
    });
  });
};

/**
 * 后台config.json
 * @param {*} req 
 * @param {*} cb 
 */
Set.prototype.setProjectConfig = function (req, cb) {
  var self = this;
  var projectConfigJson = utils.getPath("/app/" + req.projCode + "/config.json");
  fs.readFile(projectConfigJson, "utf-8", function (err, data) {
    var data0 = {};
    if (data) data0 = JSON.parse(data);
    if (!data0["miniconfig"]) data0["miniconfig"] = {};
    if (req.minisrc) data0["miniconfig"]["minisrc"] = req.minisrc;
    if (!data0["miniconfig"][req.miniCode]) data0["miniconfig"][req.miniCode] = {};
    if (req.appid) data0["miniconfig"][req.miniCode].appid = req.appid;
    if (req.appsecret) data0["miniconfig"][req.miniCode].appsecret = req.appsecret;

    if (req.mchid) data0["miniconfig"][req.miniCode].mchid = req.mchid;
    if (req.apiv3_key) data0["miniconfig"][req.miniCode].apiv3_key = req.apiv3_key;
    if (req.serial_no) data0["miniconfig"][req.miniCode].serial_no = req.serial_no;
    if (req.cert_p12) data0["miniconfig"][req.miniCode].cert_p12 = req.cert_p12;
    if (req.cert_pem) data0["miniconfig"][req.miniCode].cert_pem = req.cert_pem;
    if (req.key_pem) data0["miniconfig"][req.miniCode].key_pem = req.key_pem;
    data0["miniconfig"][req.miniCode].pathArray = req.pathArray;

    fs.writeFile(projectConfigJson, JSON.stringify(data0, null, 2), function (err) {
      cb();
    });
  });
};
