var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var exec = require('child_process').exec;

/**
 * 预览小程序
 */
var Preview = function () {
  Service.call(this);
};

util.inherits(Preview, Service);

module.exports = Preview;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Preview.prototype.process = function (req, res) {
  //serverUrl projCode miniCode
  //projectname appid
  //backgroundTextStyle navigationBarBackgroundColor navigationBarTitleText navigationBarTextStyle
  if (!req.projCode) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }
  if (!req.miniCode) {
    this.onLogicError(1, "请提供小程序编码！");
    return;
  }
 
  var self = this;
  var projectConfigFile = utils.getPath("/app/" + req.projCode + "/config.json");
  fs.readFile(projectConfigFile, "utf-8", function (err, data) {
    var baturl = "";
    if (data) {
      var data0 = JSON.parse(data);
      if (data0["miniconfig"]) {
        if (data0["miniconfig"]["minisrc"]) baturl = data0["miniconfig"]["minisrc"];
      }
    }

    if (!baturl) baturl = 'D:/Program Files (x86)/Tencent/微信web开发者工具/';
    var batstr = '"' + baturl + 'cli.bat"'; 
    var projurl = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode);
    var qrurl = utils.getPath("/web/download/" + req.projCode + "-" + req.miniCode + "-qr.png");
    var cmdStr = batstr + ' preview --project ' + projurl + ' --qr-output ' + qrurl + ' --qr-format image';
    //console.log(cmdStr);
  
    exec(cmdStr, function (err, stdout, stderr) {
      if (err) {
        self.onLogicError(1, err.message);
        return;
      }
      console.log(stdout);
      console.log(stderr);
      res.imgurl = "/download/" + req.projCode + "-" + req.miniCode + "-qr.png";
      self.end(res);
    });
  });
}; 