var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var exec = require('child_process').exec;

/**
 * 打开小程序
 */
var Open = function () {
  Service.call(this);
};

util.inherits(Open, Service);

module.exports = Open;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Open.prototype.process = function (req, res) {
  //serverUrl projCode miniCode
  //projectname appid
  //backgroundTextStyle navigationBarBackgroundColor navigationBarTitleText navigationBarTextStyle
  if (!req.projCode) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }
  if (!req.miniCode) {
    this.onLogicError(1, "请提供小程序编码！");
    return;
  }

  var self = this;
  var projectConfigFile = utils.getPath("/app/" + req.projCode + "/config.json");
  fs.readFile(projectConfigFile, "utf-8", function (err, data) {
    var baturl = "";
    if (data) {
      var data0 = JSON.parse(data);
      if (data0["miniconfig"]) {
        if (data0["miniconfig"]["minisrc"]) baturl = data0["miniconfig"]["minisrc"];
      }
    }

    if (!baturl) baturl = 'D:/Program Files (x86)/Tencent/微信web开发者工具/';
    var batstr = '"' + baturl + 'cli.bat"';
    var projurl = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode);
    var cmdStr = batstr + ' open --project ' + projurl;
    //console.log(cmdStr);

    exec(cmdStr, function (err, stdout, stderr) {
      if (err) {
        self.onLogicError(1, err.message);
        return;
      }
      self.end(res);
    });
  });
}; 