var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 获取小程序
 */
var Get = function () {
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process = function (req, res) {
  //serverUrl projCode miniCode
  //projectname appid
  //backgroundTextStyle navigationBarBackgroundColor navigationBarTitleText navigationBarTextStyle
  if (!req.projCode) {
    this.onLogicError(1, "请提供项目编码！");
    return;
  }
  if (!req.miniCode) {
    this.onLogicError(1, "请提供小程序编码！");
    return;
  }
  var self = this;
  // var miniDir = utils.getPath("/minisrc/" + req.projCode + "/" + req.miniCode);
  // if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
  // var miniprogramDir = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode);
  // if (!fs.existsSync(miniprogramDir)) fs.mkdirSync(miniprogramDir);

  res.projCode = req.projCode;
  res.miniCode = req.miniCode;
  self.getMiniProjectConfig(req, res, function () {
    self.getMiniAppConfig(req, res, function () {
      self.getMiniUtilJs(req, res, function () {
        self.getProjectConfig(req, res, function () {
          self.end(res);
        });
      });
    });
  });
};

/**
 * project.config.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.getMiniProjectConfig = function (req, res, cb) {
  var self = this;
  var miniProjectConfigFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/project.config.json");
  fs.readFile(miniProjectConfigFile, "utf-8", function (err, data) {
    var data0 = JSON.parse(data);
    if (data0.appid) res.appid = data0.appid;
    if (data0.projectname) res.projectname = data0.projectname;
    if (data0.version) res.version = data0.version;
    if (data0.release) res.release = data0.release;
    cb();
  });
};

/**
 * app.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.getMiniAppConfig = function (req, res, cb) {
  var self = this;
  var miniAppConfigFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/app.json");
  fs.readFile(miniAppConfigFile, "utf-8", function (err, data) {
    var data0 = JSON.parse(data);
    res.backgroundTextStyle = data0.window.backgroundTextStyle;
    res.navigationBarBackgroundColor = data0.window.navigationBarBackgroundColor;
    // res.navigationBarTitleText = data0.window.navigationBarTitleText ;
    res.navigationBarTextStyle = data0.window.navigationBarTextStyle;
    res.entryPagePath = data0.entryPagePath;
    var p = [];
    for (var i = 0; i < data0.pages.length; i++) {
      // if (data0.entryPagePath == data0.pages[i])
      //   p.push({ "i": i, "p": data0.pages[i], "h": true });
      // else
      p.push({ "i": i, "p": data0.pages[i] });
    }
    res.pages = p;
    cb();
  });
};

/**
 * util.js
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.getMiniUtilJs = function (req, res, cb) {
  var self = this;
  var miniUtilJs = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/utils/util.js");
  fs.readFile(miniUtilJs, "utf-8", function (err, data) {
    var d = data.substring(0, data.indexOf('\n'));
    res.serverUrl = d.split("'")[1];
    cb();
  });
};


/**
 * 后台config.json
 * @param {*} req 
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.getProjectConfig = function (req, res, cb) {
  var self = this;
  var projectConfigFile = utils.getPath("/app/" + req.projCode + "/config.json");
  fs.readFile(projectConfigFile, "utf-8", function (err, data) {
    if (data) {
      var data0 = JSON.parse(data);
      if (data0["miniconfig"]) {
        if (data0["miniconfig"]["minisrc"]) res.minisrc = data0["miniconfig"]["minisrc"];
        else res.minisrc = "D:/Program Files (x86)/Tencent/微信web开发者工具/";
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].appsecret) res.appsecret = data0["miniconfig"][req.miniCode].appsecret;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].mchid) res.mchid = data0["miniconfig"][req.miniCode].mchid;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].apiv3_key) res.apiv3_key = data0["miniconfig"][req.miniCode].apiv3_key;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].serial_no) res.serial_no = data0["miniconfig"][req.miniCode].serial_no;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].cert_p12) res.cert_p12 = data0["miniconfig"][req.miniCode].cert_p12;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].cert_pem) res.cert_pem = data0["miniconfig"][req.miniCode].cert_pem;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].key_pem) res.key_pem = data0["miniconfig"][req.miniCode].key_pem;
        if (data0["miniconfig"][req.miniCode] && data0["miniconfig"][req.miniCode].pathArray) res.pathArray = data0["miniconfig"][req.miniCode].pathArray;
      }
      else {
        if (data0[req.miniCode] && data0[req.miniCode].appsecret) res.appsecret = data0[req.miniCode].appsecret;
      }
    }
    cb();
  });
};
