var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 删除文件
 */
var DeleteFile = function () {
  Service.call(this);
};

util.inherits(DeleteFile, Service);

module.exports = DeleteFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteFile.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供文件路径！");
    return;
  }
  var self = this;
  var filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    fs.unlinkSync(filePath);
  }
  this.end(res);
};