var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('Dao');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

var GetHotAppInfo = function () {
    Service.call(this);
    this.checkLogin = false;
};

util.inherits(GetHotAppInfo, Service);

module.exports = GetHotAppInfo;

/**
 * 获取热门应用
 * @param   {Object} req 服务请求对象
 * @param   {String} req.type 0: 热门, 1: 推荐, 2: 排行
 * @param   {String} req.pageSize 条目数
 */
GetHotAppInfo.prototype.process = function (req, res) {
    requestMarket(this, {
        ...req, service: 'dp/service/market/home/getHotAppInfo'
    }, (_res) => { this.end(_res); });
};