var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('Dao');
const fs = require('fs');
const path = require('path');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

var GetDetailInfo = function () {
    Service.call(this);
    this.checkLogin = false;
};

util.inherits(GetDetailInfo, Service);

module.exports = GetDetailInfo;

/**
 * 获取应用详情
 * @param   {Object} req 服务请求对象
 * @param   {Number} req.appId 应用编号
 * @param   {Number} req.userId 应用编号
 */
GetDetailInfo.prototype.process = async function (req, res) {
    requestMarket(this, {
        ...req, service: 'dp/service/market/detail/getDetailInfo'
    }, (_res) => {
        const appInfo = _res.data;
        const _root = process.cwd();
        const appConfigFilePath = path.join(_root, appInfo.compiler == 2 ? 'dist' : 'app', appInfo.system_code, appInfo.code, 'app.json');
        const appConfig = this.getAppConfig(appConfigFilePath);
        if (appConfig && appConfig.version && appInfo.version) {
            if (appInfo.version == appConfig.version) _res.installedVersion = 2;
            else _res.installedVersion = 1;
        } else _res.installedVersion = 0;
        this.end(_res);
    });
};

/**
 * 获取应用的配置
 * @param {String} filePath 文件路径
 * @returns {Object|null}
 */
GetDetailInfo.prototype.getAppConfig = function (filePath) {
    if (!fs.existsSync(filePath)) return null;
    try {
        return JSON.parse(fs.readFileSync(filePath, 'utf8'));
    } catch (error) {
        this.onImportError(req, '读取配置文件失败！');
    }
}