var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 保存文件
 */
var SaveFile = function () {
	Service.call(this);
	this.sqlInject.exclude = ['path', 'content'];
	this.xssInject.exclude = ['path', 'content'];
};

util.inherits(SaveFile, Service);

module.exports = SaveFile;

/**
 * @param  {Object}	req 			服务请求对象
 * @param  {String} req.path 		文件路径
 * @param  {String} req.content		文件内容
 * @param  {Object} res 			服务响应对象
 */
SaveFile.prototype.process = function (req, res) {
	if (!req.path) return this.onLogicError(1, '请提供另存文件路径！');
	if (!req.content) return this.onLogicError(2, '请提供另存文件内容！');

	
	if(Object.prototype.toString.call(req.content) === '[object Object]') req.content = JSON.stringify(req.content)

	var self = this;
	fs.writeFile(req.path, req.content, function () {
		self.end(res);
	});
};