var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 文件重命名
 */
var rename = function () {
    Service.call(this);
};

util.inherits(rename, Service);

module.exports = rename;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
rename.prototype.process = function (req, res) {
    if (!req.toPath) {
        this.onLogicError(1, '请提供路径！');
        return;
    }
    if (!req.fromPath) {
        this.onLogicError(2, '请提供重命名路径！');
        return;
    }
    let toPath = req.toPath;
    let fromPath = req.fromPath;
    if (!req.isFulltoPath) toPath = utils.getPath(toPath);
    if (!req.isFullFromPath) fromPath = utils.getPath(fromPath);
    fs.renameSync(toPath, fromPath);
    this.end(res);
};