var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 判断文件是否存在
 */
var isExistsFile = function () {
    Service.call(this);
};

util.inherits(isExistsFile, Service);

module.exports = isExistsFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
isExistsFile.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');
    res.isExists = fs.existsSync(utils.getPath(req.filePath));
    this.end(res);
};