var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 判断文件是否存在
 */
var isExists = function () {
    Service.call(this);
};

util.inherits(isExists, Service);

module.exports = isExists;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
 isExists.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');
    let filePath = req.filePath;
	if (!req.isFullFilePath) filePath = utils.getPath(filePath);
    res.isExists = fs.existsSync(filePath);
    this.end(res);
};