var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 删除文件
 */
var UploadFile = function() { 
  Service.call(this);
};

util.inherits(UploadFile, Service);

module.exports = UploadFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UploadFile.prototype.process =  function(req, res) {
  if(!req.files) {
    this.onLogicError(1, '请提供文件信息！');
    return;
  }
  if(!req.dir) {
    this.onLogicError(2, '请提供目录路径！');
    return;
  }
  var self = this;
  for(var i=0;i<req.files.length;i++) {
    var filePath = utils.getPath(req.dir+"/"+req.files[i]);
    if(fs.existsSync(filePath)) {
      try {
        fs.unlinkSync(filePath);
      } catch(err) {
        self.onLogicError(3, '删除文件失败！');
        return;
      }
    }
  }
  self.end(res);
};