var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 新建文件件
 */
var createDir = function() { 
  Service.call(this);
};

util.inherits(createDir, Service);

module.exports = createDir;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
createDir.prototype.process =  function(req, res) {
  if(!req.dirPath) {
    this.onLogicError(1, '请提供文件夹名称！');
    return;
  }
  let dirPath = utils.getPath(req.dirPath);
  if(fs.existsSync(dirPath)) {
    this.onLogicError(2, "文件夹已存在！");
    return;
  }
  fs.mkdirSync(dirPath);
  this.end(res);
};