var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 将制定文件复制到目标路径
 */
var copyFile = function () {
	Service.call(this);
};

util.inherits(copyFile, Service);

module.exports = copyFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
copyFile.prototype.process = function (req, res) {
	if (!req.fromPath) return this.onLogicError(1, '请提供源文件路径！');
	if (!req.toPath) return this.onLogicError(1, '请提供目标文件路径！');

	let toPath = req.toPath;
	let fromPath = req.fromPath;
	if (!req.isFullToPath) toPath = utils.getPath(toPath);
	if (!req.isFullFromPath) fromPath = utils.getPath(fromPath);

	let fileData = fs.readFileSync(fromPath);
	fs.writeFileSync(toPath, fileData);
	this.end(res);
};