var util = require('util');
var utils = require('utils');
var Service = require('Service');
var fs = require('fs');
var path = require('path');

/**
 * 压缩代码
 */
var CompressFile = function () {
  Service.call(this);
};

util.inherits(CompressFile, Service);

module.exports = CompressFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CompressFile.prototype.process = function (req, res) {
    if (!req.type) {
        this.onLogicError(1, "请提供文件类型！");
        return;
    }
    this.jsCode = "";
    if(req.type=="tfp") {
        this.compressTfpFile(req, res, ["pc", "phone"], 0);
    } else {
        this.files = [];
        if(req.type=="tfpDesigner") {
            this.files = [{
                type: "js",
                srcFiles: [
                    "/node_modules/taskbuilder-renderer/inc/topfuncs.js",
                    "/node_modules/taskbuilder-renderer/inc/utils.js",
                    "/node_modules/taskbuilder-tfp-designer/colorPicker.js",
                    "/node_modules/taskbuilder-tfp-designer/index.js",
                    "/node_modules/taskbuilder-tfp-designer/uiDesigner.js",
                    "/node_modules/taskbuilder-tfp-designer/cssEditor.js"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/index.min.js"
            },{
                type: "js",
                srcFiles: [
                    "/node_modules/taskbuilder-renderer/inc/topfuncs.js",
                    "/node_modules/tfp/src/TFPGUIFuncCompiler.js",
                    "/node_modules/taskbuilder-tfp-designer/guiFuncDesigner.js"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/guiFuncDesigner.min.js"
            },{
                type: "js",
                srcFiles: [
                    "/node_modules/tfp/src/components/table/designer.js",
                    "/node_modules/taskbuilder-tfp-designer/page.js"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/page.min.js"
            },{
                type: "js",
                srcFiles: [
                    "/node_modules/tfp/src/TFPStatements.js"
                ],
                outFile: "/node_modules/tfp/dist/TFPStatements.min.js"
            },{
                type: "css",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/index.css",
                    "/node_modules/taskbuilder-tfp-designer/uiDesigner.css",
                    "/node_modules/taskbuilder-tfp-designer/cssEditor.css"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/index.min.css"
            },{
                type: "css",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/common.css",
                    "/node_modules/taskbuilder-tfp-designer/guiFuncDesigner.css"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/guiFuncDesigner.min.css"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPStyles.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPStyles.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPFormulas.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPFormulas.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPSysFuncs_mini.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPSysFuncs_mini.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPSysFuncs_pc.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPSysFuncs_pc.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPSysFuncs_phone.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPSysFuncs_phone.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tfp-designer/TFPVerifies.json"
                ],
                outFile: "/node_modules/taskbuilder-tfp-designer/dist/TFPVerifies.min.json"
            }];
        } else if(req.type=="tbsDesigner") {
            this.files = [{
                type: "js",
                srcFiles: [
                    "/node_modules/taskbuilder-renderer/inc/topfuncs.js",
                    "/node_modules/taskbuilder-tbs-designer/index.js"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/index.min.js"
            },{
                type: "css",
                srcFiles: [
                    "/node_modules/taskbuilder-renderer/inc/common.css",
                    "/node_modules/taskbuilder-tbs-designer/index.css"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/index.min.css"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tbs-designer/SQLFuncs_mssql.json"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/SQLFuncs_mssql.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tbs-designer/SQLFuncs_mysql.json"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/SQLFuncs_mysql.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tbs-designer/TBSStatements.json"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/TBSStatements.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tbs-designer/TBSSysFuncs.json"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/TBSSysFuncs.min.json"
            },{
                type: "json",
                srcFiles: [
                    "/node_modules/taskbuilder-tbs-designer/TBSSysVars.json"
                ],
                outFile: "/node_modules/taskbuilder-tbs-designer/dist/TBSSysVars.min.json"
            }];
        } else if(req.type=="tdmDesigner") {
            //
        } else if(req.type=="tdfDesigner") {
            //
        } else if(req.type=="tgaDesigner") {
            //
        }

        if(this.files.length==0) {
            this.end(res);
            return
        }
        
        this.compress(req, res, 0);
    }
};

/**
* 压缩tfp设计器page页jS
* @param {*} req 
* @param {*} res 
*/
CompressFile.prototype.compress = function (req, res, index) {
    if(index>=this.files.length) {
        this.end(res);
        return;
    }
    let fileGroup = this.files[index];
    this.code = "";
    this.outFilePath = fileGroup.outFile;
    const self = this;
    this.getFileContent(req, res, fileGroup.type, fileGroup.srcFiles, 0, function() {
        self.compress(req, res, index+1);
    });
};

CompressFile.prototype.compressTfpFile = function (req, res, clients, index) {
    if (index>=clients.length) {
        this.end(res);
        return;
    }
    let client = clients[index];
    let metaDatas = server.tfpLibFilesCache[client].metaDatas;
    let files = [];
    for(let cptType in metaDatas) {
        if(cptType.toLowerCase()=="grid" || cptType=="DropdownBox") continue;
        let cptMetaData = metaDatas[cptType];
        if(cptMetaData.cssFiles) {
            if(typeof(cptMetaData.cssFiles)=="string") {
                let fileName = cptMetaData.cssFiles.replace("{bgColorMode}", req.bgColorMode);
                if(fileName.indexOf("/")<0) {
                    fileName = "/node_modules/tfp/src/components/"+cptType.toLowerCase()+"/"+fileName;
                } else if(fileName.indexOf("../")==0) {
                    fileName = "/node_modules/tfp/src/components/"+fileName.substring(3);
                } 
                if(!files.includes(fileName)) files.push(fileName);
            } else if(Array.isArray(cptMetaData.cssFiles)) {
                for(let i=0;i<cptMetaData.cssFiles.length;i++) {
                    let fileInfo = cptMetaData.cssFiles[i];
                    if(typeof(fileInfo)=="string") {
                        let fileName = fileInfo.replace("{bgColorMode}", req.bgColorMode);
                        if(fileName.indexOf("{client}")>=0) fileName = fileName.replace("{client}", client);
                        if(fileName.indexOf("/")<0) {
                            fileName = "/node_modules/tfp/src/components/"+cptType.toLowerCase()+"/"+fileName;
                        } else if(fileName.indexOf("../")==0) {
                            fileName = "/node_modules/tfp/src/components/"+fileName.substring(3);
                        }
                        if(!files.includes(fileName)) files.push(fileName);
                    } else if(fileInfo.src && fileInfo.onlyDesigning) {
                        continue;
                        /*let fileName = fileInfo.src.replace("{bgColorMode}", req.bgColorMode);
                        if(fileName.indexOf("/")<0) {
                            fileName = "/node_modules/tfp/src/components/"+cptType.toLowerCase()+"/"+fileName;
                        } else if(fileName.indexOf("../")==0) {
                            fileName = "/node_modules/tfp/src/components/"+fileName.substring(3);
                        }
                        if(!files.includes(fileName)) files.push(fileName);*/
                    }
                }
            }
        }
    }
    this.code = "";
    this.outFilePath = "/node_modules/tfp/dist/style." + client + "."+req.bgColorMode+".css";
    var self = this;
    this.getFileContent(req, res, "css", files, 0, function() {
        self.compressTfpFile(req, res, clients, index+1);
    });
}

CompressFile.prototype.getFileContent = function (req, res, fileType, files, index, cb) {
    if(index>=files.length) {
        this.saveFile(req, res, fileType, cb);
        return;
    }
    let filePath = files[index];
    console.log("正在读取文件["+filePath+"]的内容...");
    filePath = utils.getPath("/web"+filePath);
    if(!fs.existsSync(filePath)) {
        console.log(filePath+"不存在！");
        this.getFileContent(req, res, fileType, files, index+1, cb);
        return;
    }
    var self = this;
    fs.readFile(filePath, "utf-8", function (err, data) {
        if (err) {
            console.log(filePath+"读取失败，错误："+err.message);
            self.getFileContent(req, res, fileType, files, index+1, cb);
            return;
        }

        self.code += data;
        self.getFileContent(req, res, fileType, files, index+1, cb);
    });
};

CompressFile.prototype.saveFile = function (req, res, fileType, cb) {
    logger.log("正在压缩代码...");
    let fileContent = "";
    if(fileType=="js") {
        var UglifyJS = server.loadModule("/node_modules/uglify-js/tools/node.js");
        fileContent = UglifyJS.minify(this.code).code;
    } else if(fileType=="css") {
        var uglifycss = server.loadModule("/node_modules/uglifycss/index.js");
        fileContent = uglifycss.processString(this.code);
    } else if(fileType=="json") {
        fileContent = JSON.stringify(JSON.parse(this.code));
    }
    this.code = null;
    let filePath = utils.getPath("/web"+this.outFilePath);
    logger.log("正在保存代码["+filePath+"]...");
    var self = this;
    fs.open(filePath, 'w+', (err, fd) => {
      if (err) {
        logger.log(err);
        fs.closeSync(fd);
        cb(res);
        return;
      }
      fs.write(fd, fileContent, (err2) => {
        fs.closeSync(fd);
        if (err2) logger.log(err2);
        cb(res);
      });
    });
};