
var dsUtils = module.exports;

dsUtils.getDsConfig = function (dsid) {
	let dsConfig = null;
  if(dsid && dsid!="default") {
    if(!server.config.DataSource) {
    	throw new Error('服务器未设置数据源！');
      return;
    }
    for(var i=0;i<server.config.DataSource.length;i++) {
      let dsTmp = server.config.DataSource[i];
      if(dsTmp.id==dsid) {
        dsConfig = dsTmp;
        break;
      }
    }
    if (!dsConfig) {
    	throw new Error('未找到ID为【'+dsid+'】的数据源！');
      return;
    }
  } else {
    dsConfig = server.config.Database;
  }
  return dsConfig;
};

dsUtils.createDao = function (service, dsid, _dsConfig) {
	let dsConfig = _dsConfig;
	if(!dsConfig) dsConfig = dsUtils.getDsConfig(dsid);
	var Dao = require('Dao_'+dsConfig.type);
  var dao = new Dao(service);
  dao.setConfig(dsConfig);
  return dao;
};