var util = require('util');
var Service = require('Service');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 开发者登录
 */
var Login = function () {
    Service.call(this);
};

util.inherits(Login, Service);

module.exports = Login;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Login.prototype.process = function (req, res) {
    var self = this;
    if (!req.uname) {
        self.onLogicError(1, '请提供登录名！');
        return;
    }
    if (!req.upwd) {
        self.onLogicError(2, '请提供登录密码！');
        return;
    }

    //向运营服务器发送请求
    requestMarket(this, {
        "service": "dp/service/tpm/login",
        "uname": req.uname,
        "upwd": req.upwd,
    }, function (retHttp) {
        res.data = retHttp;
        self.end(res);
    });
};