var util = require('util');
var Service = require('Service');
const { requestMarket } = server.loadModule("/app/dev/service/requestUtils");

/**
 * 开发者登录
 */
var DevLogin = function () {
  Service.call(this);
};

util.inherits(DevLogin, Service);

module.exports = DevLogin;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DevLogin.prototype.process = function (req, res) {
  var self = this;
  if (!req.userId) {
    self.onLogicError(1, '请提供开发者编号！');
    return;
  }
  if (!req.systemCode) {
    this.onLogicError(2, '请提供组织代码！');
    return;
  }

  //向运营服务器发送请求
  requestMarket(this, {
    "service": "dp/service/tpm/getDeveloperAuth",
    "userId": req.userId,
    "systemCode": req.systemCode
  }, function (retHttp) {
    res.user = retHttp.user;
    self.end(res);
  });
};