var Service = require("Service");
var util = require("util");
var Connection = require("Connection");
var dsUtils = require('../dsUtils');

/**
 * 获得数据库内的所有表和视图
 */
var IsTableViewExists = function () {
	Service.call(this);
	//this.checkLogin = false;
};

util.inherits(IsTableViewExists, Service);

module.exports = IsTableViewExists;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
IsTableViewExists.prototype.process = function (req, res) {
	var self = this;
  let dsConfig = dsUtils.getDsConfig(req.dsid);
  var dao = dsUtils.createDao(this, null, dsConfig);
  var connection = new Connection(dsConfig);
  dao.execute(connection.getObjectsMETA({ "object_name": req.tableName, 
		"object_type": "TABLE,VIEW" }), null, function (objectsMETA) {
		res.isExists = objectsMETA.length > 0;
		self.end(res);
	});
};