var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 创建数据模型文件
 */
var CreateModel = function () {
	Service.call(this);
};

util.inherits(CreateModel, Service);

module.exports = CreateModel;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateModel.prototype.process = function (req, res) {
	if (!req.tableName) {
		this.onLogicError(3, '请提供数据对象名称！');
		return;
	}
	this.createModelFile(req, res);
};

CreateModel.prototype.createModelFile = function (req, res) {
	var self = this;
  let dsConfig = dsUtils.getDsConfig(req.dsid);
  var dao = dsUtils.createDao(this, null, dsConfig);
  var connection = new Connection(dsConfig);
  var tdmData = {
		"table": "",
		"type": "",
		"fields": {},
		"indexs": [],
		"dbType": dsConfig.type
	}

	if(req.dsid) tdmData.dsId = dsConfig.id;

	dao.execute(connection.getObjectsMETA({ "object_name": req.tableName, "object_type": "TABLE,VIEW" }), null, function (objectsMETA) {
		var object_type = null;
		for (item of objectsMETA) if (item.object_name == req.tableName) object_type = item.object_type;
		if (!object_type) return self.onLogicError(4, '数据对象不存在！');
		tdmData.table = req.tableName;
		tdmData.type = object_type.toLowerCase();
		dao.execute(connection.getItemsMETA({
			"object_type": object_type,
			"object_name": req.tableName
		}), null, function (itemsMETA) {
			for (var i = 0; i < itemsMETA.length; i++) {
				var item = itemsMETA[i];
				tdmData.fields[item.object_name] = connection.getModelTypeDDL(item);
				tdmData.indexs.push(item.object_name);
			}
			if (tdmData.type == 'view') {
				dao.execute(connection.getDetailMETA({
					object_type: 'VIEW',
					object_name: tdmData.table
				}), [], function (sql) {
					tdmData.statement = sql[0].sql_statement;
					res.data = JSON.stringify(tdmData);
					self.end(res);
				});
			} else {
				res.data = JSON.stringify(tdmData);
				self.end(res);
			}
		});
	});
};