var Service = require("Service");
var util = require("util");
var Connection = require("Connection");
var dsUtils = require('../dsUtils');

/**
 * 获得数据库内的所有表和视图
 */
var GetTableViewList = function () {
    Service.call(this);
    //this.checkLogin = false;
};

util.inherits(GetTableViewList, Service);

module.exports = GetTableViewList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTableViewList.prototype.process = function (req, res) {
    var self = this;
    let dsConfig = dsUtils.getDsConfig(req.dsid);
    var dao = dsUtils.createDao(this, null, dsConfig);
    var connection = new Connection(dsConfig);
    dao.execute(connection.getObjectsMETA({ "object_name": req.tableName, "object_type": "TABLE,VIEW" }), null, function (objectsMETA) {
        res.tables = [];
        res.views = [];
        for (var i = 0; i < objectsMETA.length; i++) {
            var table = objectsMETA[i];
            if (table.object_type == 'TABLE') {
                if(req.getComment) {
                    res.tables.push({
                        name: table.object_name,
                        comment: table.object_comment
                    });
                } else {
                    res.tables.push(table.object_name);
                }
            }

            if (table.object_type == 'VIEW') {
                if(req.getComment) {
                    res.views.push({
                        name: table.object_name,
                        comment: table.object_comment
                    });
                } else {
                    res.views.push(table.object_name);
                }
            }
        }
        self.end(res);
    });
    return;
};