var Service = require("Service");
var util = require("util");
var Connection = require("Connection");
var dsUtils = require('../dsUtils');

/**
 * 获得数据库内的所有表和视图
 */
var GetTableViewList = function () {
    Service.call(this);
    //this.checkLogin = false;
};

util.inherits(GetTableViewList, Service);

module.exports = GetTableViewList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTableViewList.prototype.process = function (req, res) {
    var self = this;
    let dsConfig = dsUtils.getDsConfig(req.dsid);
    var dao = dsUtils.createDao(this, null, dsConfig);
    let params = [];
    let where = "";
    let type = "BASE TABLE";
    if(req.type=="view") type = "VIEW";
    if (req.keyword) where = " and (`table_name` like '%" + req.keyword + "%' or `table_comment` like '%" + req.keyword + "%')"
    let sql = "SELECT `table_name` as name,`table_comment` as `comment` "
        + "FROM `information_schema`.`TABLES` WHERE `table_schema`='" + dsConfig.database + "' "
        + "AND `table_type`='"+type+"' " + where + " ORDER BY `table_name`";
    let options = {
        sql: sql,
        params: params,
        count_sql: "select count(*) as count_ from (" + sql + ") count_rows ",
        count_params: params,
    };
    if (!req.pageSize) req.pageSize = 20;
    dao.queryDataPage(req, options, function (rows, err) {
        res.data = rows;
        self.end(res);
    });
};