var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var Dao = require('Dao');
var utils = require('utils');

/**
 * 创建数据模型文件
 */
var GetTableFields = function() { 
  Service.call(this);
};

util.inherits(GetTableFields, Service);

module.exports = GetTableFields;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTableFields.prototype.process =  function(req, res) {
  if(!req.tableName) {
    this.onLogicError(1, '请提供数据对象名称！');
    return;
  }
  var self = this;
  var dao = new Dao(this);
  dao.execute('select table_type from information_schema.TABLES '
    +'where table_schema=\''+server.config.Database.database
    +'\' and table_name=\''+req.tableName+'\'', null, function(rows1) {
    if(rows1.length==0) {
      self.onLogicError(2, '数据对象不存在！');
      return;
    }
    dao.execute('select column_name as name,data_type as type,column_comment as comment '
      +'from information_schema.COLUMNS where table_schema="'
      +server.config.Database.database+'" and table_name="'+req.tableName
      +'"', null, function(rows) {
      res.fields = rows;
      self.end(res);
    });
  });
};