var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var Dao = require('Dao');
var utils = require('utils');

/**
 * 获得TDM相对于数据库对象的改动SQL
 */
var GetTableChangeSQL = function() { 
  Service.call(this);
};

util.inherits(GetTableChangeSQL, Service);

module.exports = GetTableChangeSQL;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTableChangeSQL.prototype.process =  function(req, res) {
  if(!req.tdm) {
    this.onLogicError(1, '请提供TDM文件内容！');
    return;
  }
  var self = this;
  var dao = new Dao(this);
  dao.execute('select table_type from information_schema.TABLES '
    +'where table_schema=\''+server.config.Database.database
    +'\' and table_name=\''+req.tdm.table+'\'', null, function(rows1) {
    if(rows1.length==0) {
      self.onLogicError(2, '数据对象不存在！');
      return;
    }
    
    dao.execute('select column_name,column_default,column_key,is_nullable,extra,'
      +'data_type,character_maximum_length,numeric_precision,numeric_scale,column_comment '
      +'from information_schema.COLUMNS where table_schema=\''
      +server.config.Database.database+'\' and table_name=\''+req.tdm.table
      +'"', null, function(rows) {
      let sql = "";
      let pks = "";
      let pkModify = false;
      for(var i=0;i<req.tdm.indexs.length;i++) {
        let fieldNameNew = req.tdm.indexs[i];
        let fieldTDM = req.tdm.fields[fieldNameNew];
        let fieldDB = null;
        
        for(var j=0;j<rows.length;j++) {
          rows[j].column_name = rows[j].column_name || rows[j].COLUMN_NAME;
          rows[j].data_type = rows[j].data_type || rows[j].DATA_TYPE;
          rows[j].extra = rows[j].extra || rows[j].EXTRA;
          rows[j].numeric_precision = rows[j].numeric_precision || rows[j].NUMERIC_PRECISION;
          rows[j].numeric_scale = rows[j].numeric_scale || rows[j].NUMERIC_SCALE;
          rows[j].character_maximum_length = rows[j].character_maximum_length || rows[j].CHARACTER_MAXIMUM_LENGTH;
          rows[j].column_key = rows[j].column_key || rows[j].COLUMN_KEY;
          rows[j].is_nullable = rows[j].is_nullable || rows[j].IS_NULLABLE;
          rows[j].column_default = rows[j].column_default || rows[j].COLUMN_DEFAULT;
          rows[j].column_comment = rows[j].column_key || rows[j].COLUMN_COMMENT;
          if(rows[j].column_name==fieldTDM.oldName) {
            fieldDB = rows[j];
            break;
          }
        }
        let isModify = false;
        let isNew = false;
        if(fieldDB) {
          //列名发生变化
          if(fieldNameNew!=fieldDB.column_name) isModify = true;
          //数据类型发生变化
          console.log(fieldDB);
          if(fieldTDM.dataType.toLowerCase()!=fieldDB.data_type.toLowerCase()) {
            isModify = true;
          } else if(fieldTDM.dataType=="VARCHAR" //长度发生变化
            && fieldTDM.length!=fieldDB.character_maximum_length) {
            isModify = true;
          } else if(fieldTDM.dataType=="DECIMAL" //长度或精度发生变化
            && (fieldTDM.length!=fieldDB.numeric_precision
              || fieldTDM.scale!=fieldDB.numeric_scale)) {
            isModify = true;
          }
          //是否为空发生变化
          if((fieldTDM.notNull && fieldDB.is_nullable=='YES') 
            || (!fieldTDM.notNull && fieldDB.is_nullable=='NO')) {
            isModify = true;
          }
          //自动增长发生变化
          if((fieldTDM.autoIncrement && (!fieldDB.extra || fieldDB.extra.indexOf("auto_increment")<0))
            || (!fieldTDM.autoIncrement && fieldDB.extra && fieldDB.extra.indexOf("auto_increment")>=0)) {
            isModify = true;
          }
          //默认值发生变化
          if((fieldTDM.default && fieldTDM.default!=fieldDB.column_default) 
            || (!fieldTDM.default && (fieldDB.column_default && fieldDB.column_default!="NULL"))) {
            isModify = true;
          }
          //注释发生变化
          if((fieldTDM.comment && fieldTDM.comment!=fieldDB.column_comment) 
            || (!fieldTDM.comment && fieldDB.column_comment)) {
            isModify = true;
          }
          //主键发生变化
          if((fieldTDM.primaryKey && (!fieldDB.column_key || fieldDB.column_key.indexOf("PRI")<0)) 
            || (!fieldTDM.primaryKey && fieldDB.column_key && fieldDB.column_key.indexOf("PRI")>=0)) {
            pkModify = true;
          }
        } else {
          isNew = true;
        }
        if(fieldTDM.primaryKey) {
          if(pks!="") pks += ",";
          pks += "`"+fieldNameNew+"`";
        }
        let fieldSql = "";
        if(isModify) {
          fieldSql = "CHANGE COLUMN `"+fieldTDM.oldName+"` `"+fieldNameNew+"` ";  //修改字段
        } else if(isNew) {
          fieldSql = "ADD COLUMN `"+fieldNameNew+"` ";  //添加字段
        }
        if(fieldSql!="") {
          if(fieldTDM.dataType=="DECIMAL") {
            fieldSql += "DECIMAL("+fieldTDM.length+", "+fieldTDM.scale+")";
          } else if(fieldTDM.dataType=="VARCHAR") {
            fieldSql += "VARCHAR("+fieldTDM.length+")";
          } else {
            fieldSql += fieldTDM.dataType;
          }
          if(!fieldTDM.primaryKey && (fieldTDM.default || !fieldTDM.notNull)) {
            fieldSql += " NULL";
          } else {
            fieldSql += " NOT NULL";
          }
          if(fieldTDM.default) {
            fieldSql += " DEFAULT ";
            if(["VARCHAR","CHAR","TEXT","DATETIME","DATE","TIME"].contains(fieldTDM.dataType)) {
              fieldSql += "'"+fieldTDM.default+"'";
            } else {
              fieldSql += fieldTDM.default;
            }
          }
          if(fieldTDM.comment) fieldSql += " COMMENT '"+fieldTDM.comment+"'";
          if(fieldTDM.autoIncrement) fieldSql += " AUTO_INCREMENT ";
        }
        if(fieldSql) {
          if(sql!="") sql += ",\r\n";
          sql += fieldSql;
        }
      }
      for(var i=0;i<rows.length;i++) {
        rows[i].column_name = rows[i].column_name || rows[i].COLUMN_NAME;
        let isExists = false;
        for(fname in req.tdm.fields) {
          if(req.tdm.fields[fname].oldName==rows[i].column_name) {
            isExists = true;
            break;
          }
        }
        if(!isExists) {
          if(sql!="") sql += ",\r\n";
          sql += "DROP COLUMN `"+rows[i].column_name+"`"; 
        }
      }
      if(pkModify) {
        if(sql!="") sql += ",\r\n";
        sql += "DROP PRIMARY KEY"; 
        if(pks!="") {
          sql += ",\r\n";
          sql += "ADD PRIMARY KEY ("+pks+")"; 
        }
      }
      if(sql) sql = "ALTER TABLE `"+req.tdm.table+"` \r\n"+sql+";";
      res.sql = sql;
      self.end(res);
    });
  });
};