var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');

/**
 * 获得数据模型文件
 */
var GetDataModel = function() { 
  Service.call(this);
};

util.inherits(GetDataModel, Service);

module.exports = GetDataModel;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDataModel.prototype.process =  function(req, res) {
  var self = this;
  if(!req.projName) {
    this.onLogicError(1, '请提供项目名称！');
    return;
  }
  if(!req.modelName && !req.modelPath) {
    this.onLogicError(2, '请提供数据模型名称或路径！');
    return;
  }

  if (req.modelPath && req.modelPath.split('.').pop() == 'tdf') {
    // app/demo/tdf/l.model.l.tdf
    var tdfName = req.modelPath.split('/').pop();
    var fileName = tdfName.split('.')[0];
    var modelName = req.modelName; 
    if(!modelName) {
      modelName = fileName;
      if(tdfName.indexOf("/model")>=0) modelName = tdfName.match(/model\.(.*)\.tdf/)[1];
    }
    
    this.pipe(require('../tdf/getFileContent'), {
      filePath: '/app/' + req.modelPath.replace(tdfName, fileName + '.tdf'),
      session: req.session
    }, { ...res }, (_req, _res) => {
      res.model = JSON.parse(_res.data).models[modelName].tdm;
      self.end(res);
    });
  } else {
    var filePath = "";
    if(req.modelName) {
      let modelName = req.modelName.endWith(".tdm") ? req.modelName : req.modelName+".tdm";
      filePath = utils.getPath("/app/"+req.projName+"/model/"+modelName);
    } else if(req.modelPath) {
      if(req.modelPath.indexOf("/app/")==0) req.modelPath = req.modelPath.subtring(6);
      filePath = utils.getPath("/app/"+req.modelPath);
    }
    if(!fs.existsSync(filePath)) {
      this.onLogicError(3, '文件不存在！');
      return;
    }
    fs.readFile(filePath,"utf-8",function(err, data) {
      res.model = JSON.parse(data);
      self.end(res);
    });
  }
};