var util = require('util');
var Service = require('Service');
var utils = require('utils');
var dsUtils = require('../dsUtils');

/**
 * 执行SQL语句
 */
var exeSql = function() { 
  Service.call(this);
  this.sqlInject.exclude = ['sql'];
  this.xssInject.exclude = ['sql'];
};

util.inherits(exeSql, Service);

module.exports = exeSql;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
exeSql.prototype.process =  function(req, res) {
  req.sql = utils.trimStr(req.sql);
  if(!req.sql) {
    this.onLogicError(1, '请提供SQL语句！');
    return;
  }
  if(req.sql.trim().toLowerCase().indexOf('delete')==0 
     && req.sql.toLowerCase().indexOf(' where ')<0){
    this.onLogicError(1, '不允许全表删除！');
    return;
	}
	if(req.sql.trim().toLowerCase().indexOf('update')==0 
     && req.sql.toLowerCase().indexOf(' where ')<0){
    this.onLogicError(1, '不允许全表更新！');
    return;
	}
  let dsConfig = dsUtils.getDsConfig(req.dsid);
  if(req.sql.trim().toLowerCase().indexOf('select')==0) {
    if((dsConfig.type=="mysql" || dsConfig.type=="postgresql") 
      && req.sql.toLowerCase().indexOf(' limit ')<0) {
      req.sql += " limit 1000 ";
      //this.onLogicError(1, '请限制查询数量，不允许全库查询！');
      //return;
    } else if(dsConfig.type=="mssql" && req.sql.toLowerCase().indexOf(' top ')<0) {
      //this.onLogicError(1, '请限制查询数量，不允许全库查询！');
      //return;
    }
  }
  var self = this;
  var dao = dsUtils.createDao(this, null, dsConfig);
  dao.execute(req.sql, null, function(ret) {
    if(ret.length) {
      res.dataset = {
        columns: [],
        rows: []
      };
      for(var i=0;i<ret.length;i++) {
        let row = ret[i];
        if(i==0) {
          for(var p in row) {
            res.dataset.columns.push(p);
          }
        }
        let arr = [];
        for(var p in row) {
          arr.push(row[p]);
        }
        res.dataset.rows.push(arr);
      }
    } else {
      res.ret = ret;
    }
	  self.end(res);
  });
};