var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');
var PackageManager = require('../proj/packageManager.js');

/**
 * 创建数据模型文件
 */
var CreateModels = function () {
	Service.call(this);
	this.pkManager = new PackageManager();
};

util.inherits(CreateModels, Service);

module.exports = CreateModels;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateModels.prototype.process = function (req, res) {
	if (!req.tables) {
		this.onLogicError(1, '请提供要导入的表或视图！');
		return;
	}
	if (!req.path) {
		this.onLogicError(2, '请提供保存路径！');
		return;
	}
	let tables = req.tables.split(",");

	this.dsConfig = dsUtils.getDsConfig(req.dsid);
	this.dao = dsUtils.createDao(this, null, this.dsConfig);
	this.con = new Connection(this.dsConfig);

	this.createModelFile(req, res, tables, 0);
};

CreateModels.prototype.createModelFile = function (req, res, tables, index) {
	if (index >= tables.length) {
		this.end(res);
		return;
	}
	let tableName = tables[index];
	var tdmData = {
		"table": tableName,
		"type": "",
		"fields": {},
		"indexs": [],
		"dbType": this.dsConfig.type
	}

	if (req.dsid) tdmData.dsId = this.dsConfig.id;
	var self = this;
	this.dao.execute(this.con.getObjectsMETA({ "object_name": tableName, "object_type": "TABLE,VIEW" }), null, function (objectsMETA) {
		var object_type = null;
		for (item of objectsMETA) if (item.object_name == tableName) object_type = item.object_type;
		if (!object_type) return self.onLogicError(4, '数据对象不存在！');
		tdmData.table = tableName;
		tdmData.type = object_type.toLowerCase();
		self.dao.execute(self.con.getItemsMETA({
			"object_type": object_type,
			"object_name": tableName
		}), null, function (itemsMETA) {
			for (var i = 0; i < itemsMETA.length; i++) {
				var item = itemsMETA[i];
				tdmData.fields[item.object_name] = self.con.getModelTypeDDL(item);
				tdmData.indexs.push(item.object_name);
			}
			var filePath = utils.getPath(req.path + '/' + tableName + '.tdm');
			if (fs.existsSync(filePath)) fs.unlinkSync(filePath);
			fs.writeFileSync(filePath, JSON.stringify(tdmData, null, "\t"));

			let modelPath = req.path + '/' + tableName + '.tdm';
			self.pkManager.setModelInfo(req, modelPath.substring(5), tdmData, function () {
				self.saveRecord(tdmData, modelPath, function () {
					self.createModelFile(req, res, tables, index + 1);
				});
			});
		});
	});
};


CreateModels.prototype.saveRecord = function (tdmData, modelPath, cb) {
	var self = this;
	var dbDir = "";
	var appJsonPath = utils.getPath(modelPath.split('model')[0]) + 'app.json';
	if (!fs.existsSync(appJsonPath)) {
		cb();
		return;
	}
	var appJson = JSON.parse(fs.readFileSync(appJsonPath, 'utf8'));
	if (!appJson || (appJson && !appJson.id)) {
		cb();
		return;
	}
	var modelDir = path.dirname(modelPath);
	dbDir = utils.getPath(modelDir.replace('model', 'db'));

	// if (!fs.existsSync(dbDir)) fs.mkdirSync(dbDir);
	this.mkdirsSync(dbDir);
	var tdmDir = dbDir + '/' + tdmData.table;
	if (!fs.existsSync(tdmDir)) fs.mkdirSync(tdmDir);
	var sqlContent = '';
	var tdmSqlPath = tdmDir + '/' + tdmData.table + '_tmp.sql';
	if (fs.existsSync(tdmSqlPath)) sqlContent = fs.readFileSync(tdmSqlPath, 'utf8');
	getSqlList(function (sqlList) {
		for (var i = 0; i < sqlList.length; i++) {
			if (sqlContent && sqlContent != '') sqlContent += '\n';
			sqlContent += sqlList[i];
		}
		fs.writeFileSync(tdmSqlPath, sqlContent);

		// var packageJson = '';
		// var packagePath = path.join(tdmDir, 'package.json');
		// if (!fs.existsSync(packagePath)) {
		//     packageJson = {
		//         table: tdmData.table,
		//         type: tdmData.type,
		//         dbType: tdmData.dbType,
		//         version: 1,
		//         status: tdmData.status,
		//         record: []
		//     }
		//     fs.writeFileSync(packagePath, JSON.stringify(packageJson, null, '\t'));
		// }
		cb();
	});

	function getSqlList(cb) {
		var sqlList = [];
		var _tdmData = JSON.parse(JSON.stringify(tdmData));
		// self.pipe(require('./getCreateDDL'), { tdmData }, res, function (req1, res1) {
		//     sqlList = [...sqlList, ...res1.sqlList];
		//     tdmData = JSON.parse(JSON.stringify(self._tdmData));
		//     if (tdmData.oldVersion === 0) return cb(sqlList);
		//     else {
		_tdmData.recreate = true;
		_tdmData.blalter = false;
		_tdmData.iscreate = false;
		_tdmData.startrun = false;
		self.pipe(require('../tdm/getCreateDDL'), { tdmData: _tdmData }, { code: 0 }, function (req2, res2) {
			sqlList = [...sqlList, ...res2.sqlList];
			return cb(sqlList);
		});
		//     }
		// })
	}
};

/**
 * 递归创建目录(同步)
 * @param {*} dirname 
 * @returns 
 */
CreateModels.prototype.mkdirsSync = function (dirname) {
	var self = this;
	if (fs.existsSync(dirname)) {
		return true;
	} else {
		if (self.mkdirsSync(path.dirname(dirname))) {
			fs.mkdirSync(dirname);
			return true;
		}
	}
}
