var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');
var PackageManager = require('../proj/packageManager.js');

/**
 * 创建数据模型文件
 */
var CreateModel = function() { 
  Service.call(this);
  this.pkManager = new PackageManager();
};

util.inherits(CreateModel, Service);

module.exports = CreateModel;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateModel.prototype.process =  function(req, res) {
  if(!req.tableName) {
    this.onLogicError(3, '请提供数据对象名称！');
    return;
  }
  if(!req.path) {
    this.onLogicError(2, '请提供保存路径！');
    return;
  }
  this.createModelFile(req, res);
};

CreateModel.prototype.createModelFile = function(req, res) { 
  var self = this;
	let dsConfig = dsUtils.getDsConfig(req.dsid);
  var dao = dsUtils.createDao(this, null, dsConfig);
	var connection = new Connection(dsConfig);
	var tdmData = {
		"table": "",
		"type": "",
		"fields": {},
		"indexs": [],
    "dbType": dsConfig.type
	}

	if(req.dsid) tdmData.dsId = dsConfig.id;
	
	dao.execute(connection.getObjectsMETA({ "object_name": req.tableName, "object_type": "TABLE,VIEW" }), null, function(objectsMETA) {
		var object_type = null;
		for(item of objectsMETA) if(item.object_name == req.tableName) object_type = item.object_type;
		if(!object_type) return self.onLogicError(4, '数据对象不存在！');
		tdmData.table = req.tableName;
		tdmData.type = object_type.toLowerCase();
		dao.execute(connection.getItemsMETA({
			"object_type": object_type, 
			"object_name": req.tableName
		}), null, function(itemsMETA) {
			for(var i = 0; i < itemsMETA.length; i++) {
				var item = itemsMETA[i];
				tdmData.fields[item.object_name] = connection.getModelTypeDDL(item);
				tdmData.indexs.push(item.object_name);
			}
			var filePath = utils.getPath(req.path+'/'+req.tableName+'.tdm');
			if(fs.existsSync(filePath)) fs.unlinkSync(filePath);
			fs.writeFileSync(filePath, JSON.stringify(tdmData, null, "\t"));
			if(req.returnContent) res.data = JSON.stringify(tdmData);
			self.end(res);
		});
	});
};

CreateModel.prototype.createDaoFile = function(req, res) {
  var projName = req.path.split("/")[2];
  var className = req.tableName.substr(0,1).toUpperCase()+name.substr(1);
  var str = 'var util = require(\'util\');\r\n'
    +'var Dao = require(\'Dao\');\r\n'
    +'\r\n'
    +'var '+className+' = function(service) {\r\n'
    +'  Dao.call(this, service, \''+projName+'\', \''+req.tableName+'\');\r\n'
    +'};\r\n'
    +'\r\n'
    +'util.inherits('+className+', Dao);\r\n'
    +'\r\n'
    +'module.exports = '+className+';';
  
  var filePath = path.normalize(req.path+'/dao/'+req.tableName+'.js');
  if(fs.existsSync(filePath)) {
    fs.unlinkSync(filePath);
  }
  fs.writeFileSync(filePath,str);
  this.end(res);
};