/****************************************************
 * 
 * @author smz
 * @version 
 ***************************************************/

var util = require('util');
var uuid = require('node-uuid');
var Connection = require('Connection');
var Dao = require('Dao');

var TdfManagerBl = function (_service) {
  this.service = _service;

  this.types = {
    "text": {
      "controlType": "Text",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 200
    },
    "textarea": {
      "controlType": "TextArea",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 2000
    },
    "select": {
      "controlType": "Select",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 50
    },
    "switch": {
      "controlType": "Switch",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "radio": {
      "controlType": "Radio",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 50
    },
    "checkbox": {
      "controlType": "CheckBox",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 50
    },
    "rate": {
      "controlType": "Rate",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "slider": {
      "controlType": "Slider",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "date": {
      "controlType": "Date",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "time": {
      "controlType": "Time",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "datetime": {
      "controlType": "Date",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 20
    },
    "dep": {
      "controlType": "Dep",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 500
    },
    "user": {
      "controlType": "User",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 500
    },
    "org": {
      "controlType": "Org",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 500
    },
    "role": {
      "controlType": "Role",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 500
    },
    "fileupload": {
      "controlType": "FileUpload",
      "requestType": "json",
      "fieldType": "VARCHAR",
      "length": 2000
    },
    "photoupload": {
      "controlType": "PhotoUpload",
      "requestType": "json",
      "fieldType": "VARCHAR",
      "length": 2000
    },
    "sign": {
      "controlType": "Sign",
      "requestType": "json",
      "fieldType": "VARCHAR",
      "length": 2000
    },
    "countersign": {
      "controlType": "Countersign",
      "requestType": "json",
      "fieldType": "VARCHAR",
      "length": 2000
    },
    "record": {
      "controlType": "Record",
      "requestType": "string",
      "fieldType": "VARCHAR",
      "length": 500
    },
    "dataset": {
      "controlType": "DataSet",
      "requestType": "json",
      "fieldType": "VARCHAR",
      "length": 500
    }
  };
}

module.exports = TdfManagerBl;

/**
 * 
 * @param {*} option 
 * @param {*} option.items
 * @returns 
 */
TdfManagerBl.prototype.parseItems = function (option) {
  this.oldItems = option.items;
  this.newItems = {
    "main": []
  };

  this.tmpRowIndex = 0;
  this.loopComponents(option.tfp, option.changeVerifies, option.changeUniqueVerify);

  return this.newItems;
};

/**
 * 
 * @param {*} cpt 
 */
TdfManagerBl.prototype.loopComponents = function (cpt, changeVerifies, changeUniqueVerify) {
  if (cpt.type == "Cellbox") {
    var c = cpt.components[1].components[0];
    var col = cpt.components[0];
    var b = false;
    for (let i = 0; i < this.oldItems.main.length; i++) {
      const item = this.oldItems.main[i];
      if (item.uid == c.uid) {
        // if (item.id != c.id) item.oldName = item.id;
        item.id = c.id;
        item.title = c.titleName;
        item.fieldName = c.id;

        if (item.type.toLowerCase() == "radio") {
          item.attr = { "options": c.options }
        }
        else if (item.type.toLowerCase() == "checkbox") {
          item.attr = { "options": c.options }
        }
        else if (item.type.toLowerCase() == "select") {
          item.attr = { "jsonDataSet": c.jsonDataSet }
        }
        else if (item.type.toLowerCase() == "dep") {
          item.attr = { "multiCheck": c.multiCheck }
        }
        else if (item.type.toLowerCase() == "user") {
          item.attr = { "multiCheck": c.multiCheck }
        }
        else if (item.type.toLowerCase() == "date") {
          item.attr = { "showMode": c.multiCheck }
        }

        if (item.type.toLowerCase() != c.type.toLowerCase()) {
          item.type = c.type;
          item.requestType = this.types[item.type.toLowerCase()].requestType;
          item.fieldType = this.types[item.type.toLowerCase()].fieldType;
          item.length = this.types[item.type.toLowerCase()].length;

          // if (!item.requestType) item.requestType = "string";
          // if (!item.requestNotNull) item.requestNotNull = false;
          // if (!item.fieldType) item.fieldType = "VARCHAR";
          // if (!item.length) item.length = 200;
        }

        if (changeVerifies && changeVerifies[item.uid]) item.verify = changeVerifies[item.uid];
        if (changeUniqueVerify && changeUniqueVerify[item.uid]) item.uniqueVerify = changeUniqueVerify[item.uid];

        b = true;
        this.newItems.main.push(item);

        if (item.type.toLowerCase() == "dataset") {
          this.loopComponentsSub(c, changeVerifies, changeUniqueVerify);
        }
        break;
      }
    }

    if (!b) {
      var uid = uuid.v1().replace(/-/g, '');
      c.uid = uid;
      // c.type = c.type.toLowerCase();
      var attr = {};
      if (c.type.toLowerCase() == "radio") {
        attr = { "options": c.options }
      }
      else if (c.type.toLowerCase() == "checkbox") {
        attr = { "options": c.options }
      }
      else if (c.type.toLowerCase() == "select") {
        attr = { "jsonDataSet": c.jsonDataSet }
      }
      else if (c.type.toLowerCase() == "dep") {
        attr = { "multiCheck": c.multiCheck }
      }
      else if (c.type.toLowerCase() == "user") {
        attr = { "multiCheck": c.multiCheck }
      }
      else if (c.type.toLowerCase() == "date") {
        attr = { "showMode": c.multiCheck }
      }

      const item = {
        "uid": uid,
        "id": c.id,
        "type": c.type,
        "title": c.titleName,
        "rowIndex": this.tmpRowIndex,
        "colWidth": col.colWidth,
        "attr": attr,

        "requestType": this.types[c.type.toLowerCase()].requestType,
        "requestNotNull": false,

        "fieldName": c.id,
        "fieldType": this.types[c.type.toLowerCase()].fieldType,
        "length": this.types[c.type.toLowerCase()].length, //
        "precision": null, //
        "scale": null, //
      }

      if (changeVerifies && changeVerifies[item.uid]) item.verify = changeVerifies[item.uid];
      if (changeUniqueVerify && changeUniqueVerify[item.uid]) item.uniqueVerify = changeUniqueVerify[item.uid];

      this.newItems.main.push(item);

      if (c.type.toLowerCase() == "dataset") {
        this.loopComponentsSub(c, changeVerifies, changeUniqueVerify);
      }
    }
  }
  else {
    if (cpt.type == "Row") this.tmpRowIndex++;
    if (cpt.components) {
      for (var i = 0; i < cpt.components.length; i++) {
        this.loopComponents(cpt.components[i], changeVerifies, changeUniqueVerify);
      }
    }
  }
};

/**
 * 
 * @param {*} cpt 
 */
TdfManagerBl.prototype.loopComponentsSub = function (cpt, changeVerifies, changeUniqueVerify) {
  this.newItems["sub_" + cpt.uid] = {
    "id": cpt.id,
    "fields": []
  };

  for (let i = 0; i < cpt.columns.length; i++) {
    var c = cpt.columns[i];
    if (c.standard) continue;
    var b = false;
    if (this.oldItems["sub_" + cpt.uid]) {
      for (let j = 0; j < this.oldItems["sub_" + cpt.uid].fields.length; j++) {
        const item = this.oldItems["sub_" + cpt.uid].fields[j];
        if (item.uid == c.uid) {
          item.id = c.id;
          item.title = c.name;
          item.fieldName = c.id;

          if (item.type.toLowerCase() == "radio") {
            item.attr = { "options": c.options }
          }
          else if (item.type.toLowerCase() == "checkbox") {
            item.attr = { "options": c.options }
          }
          else if (item.type.toLowerCase() == "select") {
            item.attr = { "jsonDataSet": c.jsonDataSet }
          }
          else if (item.type.toLowerCase() == "dep") {
            item.attr = { "multiCheck": c.multiCheck }
          }
          else if (item.type.toLowerCase() == "user") {
            item.attr = { "multiCheck": c.multiCheck }
          }
          else if (item.type.toLowerCase() == "date") {
            item.attr = { "showMode": c.multiCheck }
          }


          if (item.type.toLowerCase() != c.type.toLowerCase()) {
            item.type = c.type.toLowerCase();
            item.requestType = this.types[item.type.toLowerCase()].requestType;
            item.fieldType = this.types[item.type.toLowerCase()].fieldType;
            item.length = this.types[item.type.toLowerCase()].length;
          }

          if (changeVerifies && changeVerifies[item.uid]) item.verify = changeVerifies[item.uid];
          if (changeUniqueVerify && changeUniqueVerify[item.uid]) item.uniqueVerify = changeUniqueVerify[item.uid];

          b = true;
          this.newItems["sub_" + cpt.uid].fields.push(item);
          break;
        }
      }
    }
    if (!b) {
      var uid = uuid.v1().replace(/-/g, '');
      c.uid = uid;
      // c.type = c.type.toLowerCase();
      var attr = {};
      if (c.type.toLowerCase() == "radio") {
        attr = { "options": c.options }
      }
      else if (c.type.toLowerCase() == "checkbox") {
        attr = { "options": c.options }
      }
      else if (c.type.toLowerCase() == "select") {
        attr = { "jsonDataSet": c.jsonDataSet }
      }
      else if (c.type.toLowerCase() == "dep") {
        attr = { "multiCheck": c.multiCheck }
      }
      else if (c.type.toLowerCase() == "user") {
        attr = { "multiCheck": c.multiCheck }
      }
      else if (c.type.toLowerCase() == "date") {
        attr = { "showMode": c.multiCheck }
      }

      const item = {
        "uid": uid,
        "id": c.id,
        "type": c.type,
        "title": c.name,
        "attr": attr,

        "requestType": this.types[c.type.toLowerCase()].requestType,
        "requestNotNull": false,

        "fieldName": c.id,
        "fieldType": this.types[c.type.toLowerCase()].fieldType,
        "length": this.types[c.type.toLowerCase()].length, //
        "precision": null, //
        "scale": null //
      };

      if (changeVerifies && changeVerifies[item.uid]) item.verify = changeVerifies[item.uid];
      if (changeUniqueVerify && changeUniqueVerify[item.uid]) item.uniqueVerify = changeUniqueVerify[item.uid];

      this.newItems["sub_" + cpt.uid].fields.push(item);
    }
  }
};


/**
 * 转换TFP
 * @param {*} option 参数
 * @param {*} option.type 类型(index|edit|tab)
 * @param {*} option.tfp 默认
 * @param {*} option.tabs 
 * @param {*} option.items 元素
 * @returns 
 */
TdfManagerBl.prototype.transformTFP = function (option) {
  // if (!option.tfp) option.tfp = this.defaultTFP({
  //   "type": option.type,
  //   "info": option.info
  // });
  if (!option.tfp) option.tfp = {};

  // if (!option.items) option.items = this.defaultItems({ "type": option.type });
  var json = Object.assign(option.tfp, option.param);
  option.tfp.projName = option.info.projName;
  option.tfp.tableName = option.info.projName + '_' + option.info.tableName;

  if (option.type == "edit") {
    // if (option.param.client) json.client = option.param.client;
    // if (option.param.mobileType) json.mobileType = option.param.mobileType;
    // if (option.param.framework) json.framework = option.param.framework;
    // if (option.param.positionType) json.positionType = option.param.positionType;
    // if (option.param.pageType) json.pageType = option.param.pageType;
    // if (option.param.bgColorMode) json.bgColorMode = option.param.bgColorMode;

    // if (option.param.title) json.title = option.param.title;

    var gridboxComponents = json.components[0].components[0].components[0].components[0].components[0].components[0].components;
    // if (json.title) gridboxComponents[0].components[0].value = json.title;
    if (option.items && option.items.main) {
      var tmpRow;
      var tmpRowIndex = 0;
      for (let i = 0; i < option.items.main.length; i++) {
        var item = option.items.main[i];
        if (item.rowIndex > tmpRowIndex) {
          tmpRowIndex = item.rowIndex;
          tmpRow = {
            "type": "Row",
            "id": "row" + tmpRowIndex,
            "components": []
          };
          gridboxComponents.push(tmpRow);
        }

        tmpRow.components.push({
          "type": "Col",
          "id": "col" + (i + 1),
          "styles": {},
          "colWidth": item.colWidth,
          "components": [
            {
              "type": "Cellbox",
              "id": "cellbox" + (i + 1),
              "direction": "column",
              "components": [
                {
                  "id": "cellbox" + (i + 1) + "_cellitem1",
                  "type": "Cellitem",
                  "components": [
                    {
                      "id": "label" + (i + 1),
                      "type": "Label",
                      "value": item.title + "：",
                    }
                  ],
                  "colWidth": ""
                },
                {
                  "id": "cellbox" + (i + 1) + "_cellitem2",
                  "type": "Cellitem",
                  "components": [
                    {
                      "uid": item.uid,
                      "id": item.id,
                      "titleName": item.title,
                      "dataBindingFormat": "{" + item.fieldName + "}",
                      "type": item.type,
                      "styles": {
                        "width": "100%",
                      }
                    }
                  ],
                  "colWidth": "main"
                }
              ]
            }
          ]
        });
      }
    }
  }
  else if (option.type == "index") {
    let serviceGetList = json.components[(() => {
      for (let i = 0; i < json.components.length; i++) {
        if (json.components[i].id == 'serviceGetList') { return i }
      }
      return -1;
    })()];
    const panelConfig = json.components[0].components[0];
    const toolbarConfig = panelConfig.components[0];
    const queryConfig = panelConfig.components[1];
    const gridConfig = json.components[0].components[1];

    const itemList = JSON.parse(JSON.stringify(option.items.main));
    const itemDict = {};
    itemList.forEach(item => { itemDict[item.id] = item; });
    if (
      option.page.param.selectTable &&
      option.page.param.selectTable != 'main' &&
      itemDict[option.page.param.selectTable] &&
      option.items['sub_' + itemDict[option.page.param.selectTable].uid] &&
      option.items['sub_' + itemDict[option.page.param.selectTable].uid].fields
    ) {
      const selectTable = option.page.param.selectTable;
      const dataset = JSON.parse(JSON.stringify(option.items['sub_' + itemDict[selectTable].uid].fields));
      dataset.map(item => {
        item.id = selectTable + '_' + item.id;
        item.fieldName = selectTable + '_' + item.fieldName;
        item.isDataset = true;
        return item;
      })
      itemList.push(...dataset);
      dataset.forEach(item => { itemDict[item.id] = item; });
    }

    if (option.page.param.enableDataPage == false) gridConfig.allowPaging = false;

    // serviceGetList.path = option.info.filePath.replace(/(.*)\.tdf/, `$1.service.list${option.pageIndex}.tdf`);
    serviceGetList.pathArgs = { "opType": 'service', "opName": option.page.code };
    if (option.page.param.rowHeight) {
      gridConfig.rowHeight = option.page.param.rowHeight;
    }

    var gridboxColumns = gridConfig.columns;
    if (option.page.param.autoFields) {
      for (let i = itemList.length - 1; i >= 0; i--) {
        var item = itemList[i];
        gridboxColumns.splice(0, 0, {
          "name": item.title,
          "format": "{" + item.fieldName + "}",
          "align": "center",
          "width": "150px"
        })
      }
    }
    else {
      let showSumer = false;
      for (let i = option.page.fields.length - 1; i >= 0; i--) {
        const field = option.page.fields[i];
        const item = itemDict[field.id];
        if (!field.show || !item) continue;
        gridboxColumns.splice(0, 0, {
          "name": item.title,
          "format": "{" + item.fieldName + "}",
          "align": field.align || 'center',
          "width": field.width == 'default' ? '150px' : field.width,
          "sum": field.sum
        });
        if (field.sum) showSumer = true;
      }
      if (showSumer) gridConfig.showSumer = showSumer;
    }
    if (option.page.param.isDelete == undefined || option.page.param.isDelete) {
      gridboxColumns.push({
        "format": "删除",
        "name": "删除",
        "onClick": "grid1.deleteRow({id})",
        "contentType": "button",
        "buttonTheme": "round",
        "buttonBgColor": "#FF6600",
        "buttonFontColor": "#FFFFFF",
        "align": "center",
        "width": "70px",
        "class": "no-open-update-drawer",
      });
    }

    const queryList = [];
    const buttonIndex = (() => {
      for (let i = 0; i < queryConfig.components.length; i++) {
        if (queryConfig.components[i].id == 'buttonQuery') return i;
      }
      return false;
    })()
    const buttonConfig = queryConfig.components[buttonIndex];

    (option.page.query || []).forEach(item => {
      if (item.enable && itemDict[item.id]) queryList.push(item);
    });
    if (queryList.length > 0) {
      delete buttonConfig.styles.display;
      for (let i = queryList.length - 1; i >= 0; i--) {
        const query = queryList[i];
        const item = itemDict[query.id];
        if (query.queryMode == 'dateRange') {
          queryConfig.components.splice(buttonIndex, 0, {
            "type": "FlexPanel",
            "id": "panel_query_" + item.id,
            "styles": {
              "height": "50px",
              "font-size": "0",
              "flex-grow": "0",
              "flex-shrink": "0",
              "flex-basis": "auto",
              "padding": "10px 0px 10px 10px"
            },
            "components": [
              {
                "type": "Label",
                "id": "label_" + item.id,
                "value": item.title + '：',
                "styles": {
                  "float": "left"
                }
              },
              {
                "type": "DateRange",
                "id": 'query_' + item.id,
                "value": "",
                "showIcon": true,
                "showMode": item.attr.showMode || "defaultMode",
                "styles": {
                  "display": "inline-block",
                  "width": "247px",
                  "height": "30px",
                  "flex-grow": "0",
                  "flex-shrink": "0",
                  "flex-basis": "auto",
                }
              }
            ]
          });
        }
        else if (query.queryMode == 'select') {
          queryConfig.components.splice(buttonIndex, 0, {
            "type": "FlexPanel",
            "id": "panel_query_" + item.id,
            "styles": {
              "height": "50px",
              "font-size": "0",
              "flex-grow": "0",
              "flex-shrink": "0",
              "flex-basis": "auto",
              "padding": "10px 0px 10px 10px"
            },
            "components": [
              {
                "type": "Label",
                "id": "label_" + item.id,
                "value": item.title + '：',
                "styles": {
                  "float": "left"
                }
              },
              {
                "type": "Select",
                "id": 'query_' + item.id,
                "rootParentId": "0",
                "styles": {
                  "display": "inline-block",
                  "width": "120px",
                  "height": "30px",
                  "line-height": "30px",
                  "padding-left": "2px",
                  "padding-right": "2px",
                  "flex-grow": "0",
                  "flex-shrink": "0",
                  "flex-basis": "auto"
                },
                "jsonDataSet": item.attr.jsonDataSet || {}
              }
            ]
          });
          if (itemDict[item.id].attr.jsonDataSet && !itemDict[item.id].attr.jsonDataSet.options) {
            json.components.push({
              "type": "Service",
              "id": "service_datadic_" + item.id,
              "autoShowError": true,
              "path": "sys/service/data_dic/getList.tbs",
              "argSettings": [
                {
                  "name": "type_code",
                  "type": "Default",
                  "value": itemDict[item.id].attr.jsonDataSet.type_code
                }
              ]
            })
          }
        }
        else if (query.queryMode == 'preciseDate') {
          queryConfig.components.splice(buttonIndex, 0, {
            "type": "FlexPanel",
            "id": "panel_query_" + item.id,
            "styles": {
              "height": "50px",
              "font-size": "0",
              "flex-grow": "0",
              "flex-shrink": "0",
              "flex-basis": "auto",
              "padding": "10px 0px 10px 10px"
            },
            "components": [
              {
                "type": "Label",
                "id": "label_" + item.id,
                "value": item.title + '：',
                "styles": {
                  "float": "left"
                }
              },
              {
                "type": "Date",
                "id": "query_" + item.id,
                "value": "",
                "showIcon": true,
                "showMode": item.attr.showMode || "defaultMode",
                "styles": {
                  "display": "inline-block",
                  "width": "125px",
                  "height": "30px",
                  "flex-grow": "0",
                  "flex-shrink": "0",
                  "flex-basis": "auto"
                }
              }
            ]
          });
        }
        else if (query.queryMode == 'preciseTime') {
          queryConfig.components.splice(buttonIndex, 0, {
            "type": "FlexPanel",
            "id": "panel_query_" + item.id,
            "styles": {
              "height": "50px",
              "font-size": "0",
              "flex-grow": "0",
              "flex-shrink": "0",
              "flex-basis": "auto",
              "padding": "10px 0px 10px 10px"
            },
            "components": [
              {
                "type": "Label",
                "id": "label_" + item.id,
                "value": item.title + '：',
                "styles": {
                  "float": "left"
                }
              },
              {
                "type": "Time",
                "id": "query_" + item.id,
                "showIcon": true,
                "styles": {
                  "display": "inline-block",
                  "height": "30px",
                  "width": "78px",
                  "min-width": "78px",
                  "flex-grow": "0",
                  "flex-shrink": "0",
                  "flex-basis": "auto"
                }
              }
            ]
          });
        }
        else {
          queryConfig.components.splice(buttonIndex, 0, {
            "type": "FlexPanel",
            "id": "panel_query_" + item.id,
            "styles": {
              "height": "50px",
              "font-size": "0",
              "flex-grow": "0",
              "flex-shrink": "0",
              "flex-basis": "auto",
              "padding": "10px 0px 10px 10px"
            },
            "components": [
              {
                "type": "Label",
                "id": "label_" + item.id,
                "value": item.title + '：',
                "styles": {
                  "float": "left"
                }
              },
              {
                "type": "Text",
                "id": "query_" + item.id,
                "dataType": "text",
                "styles": {
                  "width": "120px",
                  "height": "30px",
                  "line-height": "30px",
                  "padding-left": "2px",
                  "padding-right": "2px",
                  "float": "left"
                },
                "value": "",
                "placeHolder": "请输入" + item.title
              }
            ]
          });
        }
        serviceGetList.argSettings.push({
          "name": item.fieldName,
          "type": "ComponentVal",
          "value": 'query_' + item.id
        });
      }
    }

    for (let i = 0; i < toolbarConfig.components.length; i++) {
      if (toolbarConfig.components[i].id == 'button_add') {
        toolbarConfig.components[i].styles.display =
          (option.page.param.isCreate == false ? 'none' : 'inline-block');
      }
    }

    if (option.page.param.selectTable && option.page.param.selectTable != 'main') {
      delete gridConfig.onCellClick
    }
  }
  else if (option.type == "tab") {
    // if (!option.tfp) option.tfp = {};
    if (option.tabs && option.tabs.enable) {
      delete option.tfp.components[0].styles.display;
      option.tabs.pages.forEach((page, index) => {
        option.tfp.components[0].components.push({
          "id": page.code,
          "type": "TabPage",
          "isAttached": true,
          "title": page.name,
          "styles": {
            "display": index == 0 ? 'block' : 'none'
          },
          "components": [
            {
              "type": "Iframe",
              "id": `iframe${index}`,
              "frameBorder": 0,
              "marginWidth": 0,
              "marginHeight": 0,
              "styles": {
                "position": "relative",
                "left": 0,
                "top": 0,
                "width": "100%",
                "height": "100%",
                "border-color": "#CCCCCC",
                "border-width": "1px",
                "border-style": "solid",
                "background-color": "#FFFFFF"
              },
              "src": "",
              // "onAfterInitRuntime": `iframe${index}_onAfterInitRuntime()`
            }
          ]
        });
        // option.tfp.jsFuncs.push({
        //   "name": `iframe${index}_onAfterInitRuntime`,
        //   "comment": "组件初始化后",
        //   "editType": "code",
        //   "args": [],
        //   "code": `\n  if(iframe${index}.css('display')!='none') iframe${index}.attr('src', location.pathname.substring(location.pathname.lastIndexOf('/')+1).replace('index','index${index}'));\r\n`
        // });
        option.tfp.components[1].styles.display = 'none';
        option.tfp.components[1].onAfterInitRuntime = '';
      });
    }
    else {
      option.tfp.components[0].styles.display = 'none';
      option.tfp.components[1].onAfterInitRuntime = 'iframe_onAfterInitRuntime()';
      option.tfp.components[0].components = [{
        "id": option.tabs.pages[0].code,
        "type": "TabPage",
        "components": []
      }];
      delete option.tfp.components[1].styles.display;
    }
    // return option.tfp;
  }
  else if (option.type == "mEdit") {
    const phoneEdit = JSON.parse(JSON.stringify(option.phoneEdit));
    const itemList = JSON.parse(JSON.stringify(option.items.main));
    const itemDict = {};
    itemList.forEach(item => { itemDict[item.id] = item; });
    const itemDefaultCpt = {
      "type": "FlexBox",
      "id": "flexBox1",
      "styles": {
        "display": "flex",
        'flex-direction': 'column',
        "width": "100%",
        "padding": "0rem 1.25rem 0.35rem 1.25rem"
      },
      "components": [
        {
          "id": "flexBox1_panel1",
          "type": "Panel",
          "styles": {
            "width": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": [
            {
              "type": "Label",
              "id": "",
              "value": "",
              "styles": {
                "height": "30px",
                "line-height": "30px",
                "float": "left"
              }
            }
          ]
        },
        {
          "id": "flexBox1_panel2",
          "type": "Panel",
          "styles": {
            "flex": "1 1",
          },
          "components": []
        }
      ]
    }
    // 用id搜索控件中的属性添加到对象中
    const idDict = (() => {
      const dict = {};
      getDict(option.editTfp.components);

      function getDict(cpts) {
        cpts.forEach(cpt => {
          if (cpt.id) dict[cpt.id] = cpt;
          if (cpt.components) {
            getDict(cpt.components);
          }
        });
      }
      return dict;
    })();

    // 检验数据完整性
    const itemIds = Object.keys(itemDict);
    phoneEdit.fields.forEach(field => {
      const index = itemIds.indexOf(field.id);
      if (index > -1) itemIds.splice(index, 1);
    });
    itemIds.forEach(itemId => {
      const item = itemDict[itemId] || {};
      phoneEdit.fields.push({
        id: item.id,
      });
    });

    // 将控件轮询添加到tfp配置中
    const formCpt = json.components[0];
    (phoneEdit.param.autoFields ? itemList : (phoneEdit.fields || [])).forEach((item, index) => {
      const itemCpt = JSON.parse(JSON.stringify(itemDefaultCpt));
      const cpt = JSON.parse(JSON.stringify(idDict[item.id]));
      if (!cpt) return true;
      itemCpt.id = `flexBox${index}`;
      itemCpt.components[0].id = `flexBox${index}_panel1`;
      itemCpt.components[0].components[0].id = `label${index}`;
      itemCpt.components[0].components[0].value = `${itemDict[item.id].title}：`;
      if (cpt.required) itemCpt.components[0].components[0].attach = 'prefix';
      itemCpt.components[1].id = `flexBox${index}_panel2`;
      itemCpt.components[1].components.push(cpt);
      // 特殊判断控件web与phone差异
      switch (cpt.type) {
        case 'DataSet':
          itemCpt.components.splice(0, 1);
          cpt.inputs = JSON.parse(JSON.stringify(cpt.columns));
          if (Array.isArray(cpt.inputs) && cpt.inputs.length > 0) {
            cpt.inputs.forEach((ipt) => {
              ipt.type = ipt.type.toLowerCase();
              ipt.proportion = '1:2';
            });
          }
          delete cpt.columns;
          break;
      }

      formCpt.components.push(itemCpt);
    });

    // 将数据字典服务复制到移动端中
    option.editTfp.components.forEach(component => {
      if (component.path == 'sys/service/data_dic/getList.tbs') json.components.push(component);
    });
  }
  else if (option.type == "mList") {
    const itemList = JSON.parse(JSON.stringify(option.items.main));
    const itemDict = {};
    itemList.forEach(item => { itemDict[item.id] = item; });
    const itemDefaultCpt = {
      "type": "FlexBox",
      "id": "flexBox1",
      "styles": {
        "display": "flex",
        "width": "100%",
        "padding": "8px 16px",
        "overflow": "hidden"
      },
      "components": [
        {
          "id": "",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": [
            {
              "type": "Label",
              "id": "label1",
              "value": "",
              "styles": {
                "height": "30px",
                "line-height": "30px",
                "float": "left",
                "width": "100%",
                "text-overflow": "ellipsis",
                "overflow": "hidden",
                "white-space": "nowrap"
              }
            }
          ]
        },
        {
          "id": "",
          "type": "Panel",
          "styles": {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": [
            {
              "type": "Label",
              "id": "",
              "value": "",
              "styles": {
                "float": "left",
                "width": "100%",
                "height": "100%",
                "text-overflow": "ellipsis",
                "overflow": "hidden",
                "white-space": "nowrap"
              },
              "dataBindingFormat": ""
            }
          ]
        }
      ]
    }

    const toolbarCpt = {
      "type": "FlexBox",
      "id": "flexBox_toolbar",
      "styles": {
        "display": "flex",
        "width": "100%",
        "height": "50px",
        "padding": "5px 20px 5px 20px"
      },
      "components": [
        {
          "id": "flexBox_toolbar_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "120px",
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        },
        {
          "id": "flexBox_toolbar_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": [
            {
              "type": "Button",
              "id": "deleteBtn",
              "value": "删除",
              "labelHeight": "30",
              "imageWidth": 24,
              "imageHeight": 24,
              "styles": {
                "cursor": "pointer",
                "padding-left": "10px",
                "padding-right": "10px",
                "text-align": "center",
                "float": "right",
                "width": "60px"
              },
              "buttonType": "danger",
              "onClick": "deleteRow({id})"
            },
            {
              "type": "Button",
              "id": "updateBtn",
              "value": "修改",
              "labelHeight": "30",
              "imageWidth": 24,
              "imageHeight": 24,
              "styles": {
                "cursor": "pointer",
                "padding-left": "10px",
                "padding-right": "10px",
                "text-align": "center",
                "float": "right",
                "width": "60px",
                "margin-right": "10px"
              },
              "buttonType": "primary",
              "onClick": "gotoMEditPage({id})"
            }
          ]
        }
      ]
    }

    const gridCpt = json.components[0];
    const gridDataRowCpt = gridCpt.components[0];

    // 修改获取列表服务
    let serviceGetList = json.components[(() => {
      for (let i = 0; i < json.components.length; i++) {
        if (json.components[i].id == 'serviceGetList') { return i }
      }
      return -1;
    })()];
    serviceGetList.pathArgs = { "opType": 'service', "opName": option.page.code };

    // 修改显示列表
    let fristShow = false;
    let fieldList = null;
    if (option.page.param.autoFields) {
      fieldList = [...itemList];
      fieldList.length = 5;
    }
    else fieldList = option.page.fields;
    fieldList.forEach((field, index) => {
      const item = itemDict[field.id];
      if (!item) return true;
      const itemCpt = JSON.parse(JSON.stringify(itemDefaultCpt));
      itemCpt.id = `flexBox${index}`;
      itemCpt.components[0].id = `flexBox${index}_panel1`;
      itemCpt.components[0].components[0].id = `label${index}`;
      itemCpt.components[0].components[0].value = `${item.title}：`;
      itemCpt.components[1].id = `flexBox${index}_panel2`;
      itemCpt.components[1].components[0].id = item.id;
      itemCpt.components[1].components[0].dataBindingFormat = `{${item.fieldName}}`;
      if (field.show == false) itemCpt.styles.display = 'none';
      gridDataRowCpt.components.push(itemCpt);

      // 修改双列显示的样式
      if (option.page.param.layout == '2') {
        itemCpt.styles['width'] = '50%';
        itemCpt.styles['flex-direction'] = 'column';
        itemCpt.components[0].styles['flex-basis'] = '30px';
      }

      // 修改首行样式
      if ((field.show == true && !fristShow) || (option.page.param.autoFields && !fristShow)) {
        itemCpt.styles['width'] = '100%';
        itemCpt.components[0].styles['height'] = '0px';
        itemCpt.components[0].styles['flex-basis'] = '0rem';
        itemCpt.components[0].components[0].value = '';
        itemCpt.components[1].styles['width'] = '100%';
        itemCpt.components[1].components[0].style = 'font-weight: bold;font-size: 18px;';
        fristShow = true;
      }
    });

    // 添加按钮组
    gridDataRowCpt.components.push(toolbarCpt);

    // 添加按钮
    if (!option.page.param.isCreate) {
      let pageOnLoadjsFuncs = (() => {
        for (let i = 0; i < json.jsFuncs.length; i++) {
          const jsFunc = json.jsFuncs[i];
          if (jsFunc.name == 'page1_onLoad') return jsFunc;
        }
      })();
      for (let i = 0; i < pageOnLoadjsFuncs.statements.length; i++) {
        const statement = pageOnLoadjsFuncs.statements[i];
        if (statement.category == 'extend' && statement.type == 'setToolBtn') pageOnLoadjsFuncs.statements[i] = null;
      }
      pageOnLoadjsFuncs.statements = pageOnLoadjsFuncs.statements.filter(Boolean);
    }

    // 删除按钮
    if (!option.page.param.isDelete) {
      toolbarCpt.components[1].components[0].styles['display'] = 'none';
    }

    // 分页
    gridCpt.allowPaging = option.page.param.enableDataPage;

    // 搜索
    gridCpt.showSearchBox = option.page.query.some(item => { return item.enable })
  }
  return json;
};

/**
 * 转换TBS
 * @param {object} option 参数
 * @param {string} option.type 类型(save|get|list|remove)
 * @param {object} option.tbs 默认TODO
 * @param {object} option.items 元素
 * @param {object} option.info 信息
 * @param {object} option.param 参数
 * @param {object} option.page 页面配置
 * @param {object} option.pageIndex 页面序号
 * @returns 
 */
TdfManagerBl.prototype.transformTBS = function (option, session) {
  // if (!option.tbs) {
  //   // option.tbs = {};
  //   option.tbs = this.defaultTBS({
  //     "type": option.type,
  //     "info": option.info
  //   })
  // }

  // if (!option.tbs) option.tbs = {}; //
  // json = Object.assign(option.tbs, option.param);//

  var json; //Object.assign(option.tbs, option.param);

  if (option.type == "save") {
    json = this.defaultTBS({
      "type": option.type,
      "info": option.info
    });
    if ([true, false].includes(option.info.notCheckLogin)) json.notCheckLogin = option.info.notCheckLogin;
    if ([true, false].includes(option.info.notCheckSQLInject)) json.notCheckSQLInject = option.info.notCheckSQLInject;
    var reqArgs = json.reqArgs;
    var endMarkUpdate = json.methods[0].statements[0].statements;
    var endMarkInsert = json.methods[0].statements[0].elseStatements;

    if (option.items) {
      if (option.items.main) {
        var updateMainJson = this.defaultTBSMain({
          "type": option.type,
          "info": option.info,
          "other": { "type": "update" }
        });
        var insertMainJson = this.defaultTBSMain({
          "type": option.type,
          "info": option.info,
          "other": { "type": "insert" }
        });

        for (let i = 0; i < option.items.main.length; i++) {
          var item = option.items.main[i];
          const reqArg = {
            "name": item.id,
            "type": item.requestType,
            "notNull": item.requestNotNull ? true : false
          }
          reqArgs.push(reqArg);
          if (item.verify && typeof item.verify == 'object' && item.verify.verify && item.verify.verifyMsg && item.verify.backEnd) {
            reqArg.verify = item.verify.verify;
          }

          var strFV = "req." + item.id;
          if (item.type.toLowerCase() == "dataset") strFV = "req." + item.id + ".length";
          if (updateMainJson) {
            updateMainJson.fields.push({
              "name": item.fieldName,
              "value": strFV
            });
          }
          if (insertMainJson) {
            insertMainJson.fields.push({
              "name": item.fieldName,
              "value": strFV
            });
          }
        }

        if (updateMainJson) {
          json.methods[0].statements[0].statements.push(updateMainJson);
          endMarkUpdate = updateMainJson.statements;
        }

        if (insertMainJson) {
          json.methods[0].statements[0].elseStatements.push(insertMainJson);
          endMarkInsert = insertMainJson.statements;
        }
      }

      for (var m in option.items) {
        if (m != "main") {
          var updateSubJson = this.defaultTBSSub({
            "type": option.type,
            "info": option.info,
            "other": {
              "type": "insertupdate",
              "subTableName": option.items[m].id
            }
          });

          var insertSubJson = this.defaultTBSSub({
            "type": option.type,
            "info": option.info,
            "other": {
              "type": "insert",
              "subTableName": option.items[m].id
            }
          });

          for (let j = 0; j < option.items[m].fields.length; j++) {
            var subItem = option.items[m].fields[j];
            // reqArgs.push({
            //   "name": item.id,
            //   "type": item.requestType,
            //   "notNull": item.requestNotNull ? true : false
            // });

            if (updateSubJson) {
              updateSubJson.statements[0].fields.push({
                "name": subItem.fieldName,
                "value": "#{" + subItem.fieldName + "}"
              });
              updateSubJson.statements[0].fields.push({
                "name": subItem.fieldName,
                "value": "#{" + subItem.fieldName + "}"
              });
            }
            if (insertSubJson) {

              insertSubJson.fields.push({
                "name": subItem.fieldName,
                "value": "#{" + subItem.fieldName + "}"
              });
            }
          }

          if (updateSubJson) {
            endMarkUpdate.push(updateSubJson);
            endMarkUpdate = updateSubJson.statements[0].statements;
          }

          if (insertSubJson) {
            endMarkInsert.push(insertSubJson);
            endMarkInsert = insertSubJson.statements;
          }
        }
      }

      endMarkUpdate.push(this.defaultTBSEnd());
      endMarkInsert.push(this.defaultTBSEnd());
    }
    else {
      endMarkUpdate.push(this.defaultTBSEnd());
      endMarkInsert.push(this.defaultTBSEnd());
    }
  }
  else if (option.type == "get") {
    json = this.defaultTBS({
      "type": option.type,
      "info": option.info
    });

    if ([true, false].includes(option.info.notCheckLogin)) json.notCheckLogin = option.info.notCheckLogin;
    if ([true, false].includes(option.info.notCheckSQLInject)) json.notCheckSQLInject = option.info.notCheckSQLInject;
    var endMark = json.methods[0].statements[0].statements;
    if (option.items) {
      if (option.items.main) {
        var mainJson = this.defaultTBSMain({
          "type": option.type,
          "info": option.info
        });

        if (mainJson) {
          for (let i = 0; i < option.items.main.length; i++) {
            var item = option.items.main[i];
            mainJson.fields.push({
              "name": item.fieldName
            });
          }

          json.methods[0].statements[0].statements.push(mainJson);
          endMark = mainJson.statements;
        }
      }

      for (var m in option.items) {
        if (m != "main") {
          var subJson = this.defaultTBSSub({
            "type": option.type,
            "info": option.info,
            "other": {
              "subTableName": option.items[m].id
            }
          });

          if (subJson) {
            for (let j = 0; j < option.items[m].fields.length; j++) {
              var subItem = option.items[m].fields[j];
              subJson.fields.push({
                "name": subItem.fieldName
              });
            }
            endMark.push(subJson);
            endMark = subJson.statements;
          }
        }
      }

      endMark.push(this.defaultTBSEnd());
    }
    else {
      endMark.push(this.defaultTBSEnd());
    }
  }
  else if (option.type == "list") {
    json = this.defaultTBS({
      "type": option.type,
      "info": option.info
    });
    if ([true, false].includes(option.info.notCheckLogin)) json.notCheckLogin = option.info.notCheckLogin;
    if ([true, false].includes(option.info.notCheckSQLInject)) json.notCheckSQLInject = option.info.notCheckSQLInject;
    var endMark = json.methods[0].statements;

    if (option.items) {
      if (option.items.main) {
        var mainJson = this.defaultTBSMain({
          "type": option.type,
          "info": option.info
        });

        if (mainJson) {
          mainJson = this.transformTBSList(mainJson, option, session);
          json.methods[0].statements.push(mainJson);
          endMark = mainJson.statements;
        }
      }
      endMark.push(this.defaultTBSEnd());
    }
    else {
      endMark.push(this.defaultTBSEnd());
    }
  }
  else if (option.type == "remove") {
    json = this.defaultTBS({
      "type": option.type,
      "info": option.info
    });

    if ([true, false].includes(option.info.notCheckLogin)) json.notCheckLogin = option.info.notCheckLogin;
    if ([true, false].includes(option.info.notCheckSQLInject)) json.notCheckSQLInject = option.info.notCheckSQLInject;
    var endMark = json.methods[0].statements;
    if (option.items) {
      if (option.items.main) {
        var mainJson = this.defaultTBSMain({
          "type": option.type,
          "info": option.info
        });

        if (mainJson) {
          json.methods[0].statements.push(mainJson);
          endMark = mainJson.statements;
        }
      }

      for (var m in option.items) {
        if (m != "main") {
          var subJson = this.defaultTBSSub({
            "type": option.type,
            "info": option.info,
            "other": {
              "subTableName": option.items[m].id
            }
          });

          if (subJson) {
            endMark.push(subJson);
            endMark = subJson.statements;
          }
        }
      }

      endMark.push(this.defaultTBSEnd());
    }
    else {
      endMark.push(this.defaultTBSEnd());
    }
  }

  return json;
};

/**
 * 转换tbs.list中查询、筛选、排序
 * @param {object} json 配置
 * @param {object} option 参数
 */
TdfManagerBl.prototype.transformTBSList = function (json, option, session) {
  const itemList = JSON.parse(JSON.stringify(option.items.main));
  const itemDict = {};
  itemList.forEach(item => { itemDict[item.id] = item; });
  const selectTable = option.page.param.selectTable;
  const isDataset = (
    selectTable && selectTable != 'main' && itemDict[selectTable] &&
    option.items[`sub_${itemDict[selectTable].uid}`] &&
    option.items[`sub_${itemDict[selectTable].uid}`].fields
  );
  const mainTableName = `${option.info.projName}/${option.info.dataPath ? option.info.dataPath + '/' : ''}${option.info.dataName}`.replaceAll('/', "_");
  const subTableName = isDataset ? `${mainTableName}_${option.page.param.selectTable}` : mainTableName;

  if (option.page.param.enableDataPage == false) json.enableDataPage = false;

  itemList.map(item => {
    item.fieldAlias = item.fieldName;
    item.fieldName = `${mainTableName}.${item.fieldName}`;
    item.dataset = mainTableName;
    return item;
  });
  if (isDataset) {
    const dataset = JSON.parse(JSON.stringify(option.items[`sub_${itemDict[selectTable].uid}`].fields));
    dataset.forEach(item => {
      itemList.push({
        ...item,
        id: `${selectTable}_${item.id}`,
        fieldName: `${subTableName}.${item.fieldName}`,
        fieldAlias: `${selectTable}_${item.fieldName}`,
        dataset: subTableName
      });
    });
  }
  itemList.forEach(item => { itemDict[item.id] = item; });

  transformField();
  transformFrom();
  transformQuery();
  transformWhere();
  transformOrder();

  function transformField() {
    json.fields.push({
      "name": `${mainTableName}.id`
    });
    for (let i = 0; i < itemList.length; i++) {
      const item = itemList[i];
      const temp = {
        name: item.fieldName,
        alias: item.fieldAlias
      };
      if (item.type == 'Select' && item.attr.jsonDataSet && item.attr.jsonDataSet.type_code)
        temp.name = `(select name from sys_data_dic where type_code=\\'${item.attr.jsonDataSet.type_code}\\' and status=0 and org_id=${session.orgId} and code=${item.fieldName})`
      else if (['Dep', 'User', 'Org', 'Role'].includes(item.type))
        temp.name = `${item.attr.multiCheck ? 'getnames' : 'getname'}(${item.fieldName})`;
      else if (['FileUpload', 'PhotoUpload', 'Sign', 'Countersign'].includes(item.type))
        temp.name = `(CASE WHEN ${item.fieldName} is null THEN \\'无\\' ELSE \\'有\\' END)`;
      json.fields.push(temp);
    }
  }

  function transformFrom() {
    if (isDataset) {
      json.model = {
        "name": subTableName,
        "alias": subTableName,
      }
      json.joins.push({
        "join": "left join",
        "name": mainTableName,
        "alias": mainTableName,
        "on": `${mainTableName}.id=${subTableName}.tb_rid`,
      })
    }
    else {
      json.model = {
        "name": mainTableName,
        "alias": mainTableName,
      }
    }
  }

  function transformQuery() {
    const listQueryArgs = json.queryArgs;
    const queryList = [];
    (option.page.query || []).forEach(query => {
      const item = itemDict[query.id];
      if (query.enable && item) queryList.push(query);
    });

    for (let i = 0; i < queryList.length; i++) {
      const query = queryList[i];
      const item = itemDict[query.id];
      const queryItem = { ...item, ...query };
      if (option.info.viewParam.client == 'phone') queryItem.fieldAlias = 'keyword';
      listQueryArgs.push(getQueryJson(queryItem));
    }

    function getQueryJson(item) {
      switch (item.queryMode) {
        case 'like': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} like {%req.${item.fieldAlias}%}`
        }
        case 'precise': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} = {req.${item.fieldAlias}}`
        }
        case 'dateRange': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} between {req.${item.fieldAlias}.start} and {req.${item.fieldAlias}.end}`
        }
        case 'select': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} = {req.${item.fieldAlias}}`
        }
        case 'preciseDate': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} = {req.${item.fieldAlias}}`
        }
        case 'preciseTime': return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} = {req.${item.fieldAlias}}`
        }
        default: return {
          "name": item.fieldAlias,
          "comment": item.title,
          "condition": `${item.fieldName} like {%req.${item.fieldAlias}%}`
        }
      }
    }
  }

  function transformWhere() {
    let listWhereArgs = json.where;
    (option.page.where || []).forEach((where, index) => {
      const item = itemDict[where.id];
      if (!item || (!['IS NULL', 'IS NOT NULL'].includes(where.operator) && !where.value)) return true;

      if (listWhereArgs != '') listWhereArgs += (' ' + (where.logic || 'and') + ' ');
      listWhereArgs += (' ' + item.fieldName + ' ');
      listWhereArgs += getOperatorRightExpr(where.operator, where.value);
    });
    if (listWhereArgs != '') {
      listWhereArgs += ' and';
    }
    listWhereArgs += ` ${mainTableName}.tb_status=0`;
    if (isDataset) listWhereArgs += ` and ${subTableName}.tb_status=0`;
    json.where = listWhereArgs;
  }

  function transformOrder() {
    const listOrderArgs = json.orders;
    (option.page.order || []).forEach(order => {
      const item = itemDict[order.id];
      if (!item) return true;
      listOrderArgs.push({
        name: item.fieldName,
        order: order.orderMode
      });
    });
  }

  function getOperatorRightExpr(operator, value) {
    const KEYS = {
      SPACE: ' ',
      POINT: '.',
      SPLIT: ',',
      DISTINCT: 'DISTINCT',
      SELECT: 'SELECT',
      FROM: 'FROM',
      WHERE: 'WHERE',
      GROUP: 'GROUP BY',
      HAVING: 'HAVING',
      AS: 'AS',
      ON: 'ON',
    }
    let sqlStr = '';
    operator = operator || '';
    value = value || '';

    if (['IS NULL', 'IS NOT NULL'].includes(operator)) {
      joinSqlStr(operator);
      return sqlStr;
    }

    if (['=', '!=', '>', '<', '>=', '<='].includes(operator)) {
      joinSqlStr(operator, KEYS.SPACE, value);
      return sqlStr;
    }

    if (['IN', 'NOT IN'].includes(operator)) {
      const replaceDict = {
        'IN': 'IN ($0)',
        'NOT IN': 'NOT IN ($0)'
      };
      joinSqlStr(replaceDict[operator].replace('$0', value));
      return sqlStr;
    }

    if (['BETWEEN AND', 'NOT BETWEEN AND'].includes(operator)) {
      const replaceDict = {
        'BETWEEN AND': 'BETWEEN $0 AND $1',
        'NOT BETWEEN AND': 'NOT BETWEEN $0 AND $1'
      };
      const splitArray = value.split(',');
      splitArray.length = 2;
      const temp = [...splitArray];
      temp.map(item => { return item || '' });
      joinSqlStr(KEYS.SPACE, replaceDict[operator].replace('$0', temp[0]).replace('$1', temp[1]));
      return sqlStr;
    }
    if (['LIKE%', '%LIKE', '%LIKE%', 'NOT LIKE%', 'NOT %LIKE', 'NOT %LIKE%'].includes(operator)) {
      const replaceDict = {
        'LIKE%': 'LIKE \'$0%\'',
        '%LIKE': 'LIKE \'%$0\'',
        '%LIKE%': 'LIKE \'%$0%\'',
        'NOT LIKE%': 'NOT LIKE \'$0%\'',
        'NOT %LIKE': 'NOT LIKE \'%$0\'',
        'NOT %LIKE%': 'NOT LIKE \'%$0%\'',
      };
      joinSqlStr(KEYS.SPACE, replaceDict[operator].replace('$0', value));
      return true;
    }

    return sqlStr;

    function joinSqlStr(...str) { return sqlStr += str.join('') }
  }

  return json;
}

/**
 * 转换TDM
 * @param {object} option 参数
 * @param {object} option.tdm 原
 * @param {object} option.fields 新 //models
 * @param {object} option.mode 模式（create创建|alter修改）
 * @param {*} cb 
 */
TdfManagerBl.prototype.transformTDM = function (option, cb) {
  if (!option.tdm) option.tdm = {};
  var json = Object.assign(option.tdm, {});
  var standardFields0 = ["id"];
  var standardFields1 = ["tb_status", "tb_ctime", "tb_cuserid", "tb_utime", "tb_uuserid", "tb_dtime", "tb_duserid", "tb_rid", "tb_info"];

  var oldFields = option.tdm.fields;
  var fields = {};
  var indexs = [];
  var bb = false;

  for (let a = 0; a < standardFields0.length; a++) {
    var f = standardFields0[a];
    fields[f] = oldFields[f];
    if (option.mode != "create") {
      fields[f].oldVersion = fields[f].version;
    }
    indexs.push(f);
  }

  if (option.fields) {
    for (let i = 0; i < option.fields.length; i++) {
      var item = option.fields[i];

      var b = false;
      for (var oldName in oldFields) {
        var oldField = oldFields[oldName];
        if (item.uid == oldField.uid) {

          // oldField.dataType
          // oldField.notNull
          // oldField.comment
          // oldField.length
          // oldField.precision
          // oldField.scale


          if (item.id != oldName) {
            fields[item.id] = {
              "uid": item.uid,
              "dataType": item.fieldType ? item.fieldType : "VARCHAR",
              "type": item.requestType ? item.requestType : "string",
              "notNull": item.requestNotNull ? true : false,
              "length": item.length,
              "precision": item.precision,
              "scale": item.scale,
              "comment": item.title ? item.title : "",
              "version": oldField.version + 1,
              "status": 0,
              "oldVersion": oldField.version,
              "oldName": oldName,
              "oldNotNull": oldField.notNull
            }
            bb = true;
          }
          else {
            fields[item.id] = {
              "uid": item.uid,
              "dataType": item.fieldType ? item.fieldType : "VARCHAR",
              "type": item.requestType ? item.requestType : "string",
              "notNull": item.requestNotNull ? true : false,
              "length": item.length,
              "precision": item.precision,
              "scale": item.scale,
              "comment": item.title ? item.title : "",
              "version": oldField.version,
              "status": 0,
              "oldVersion": oldField.version
            }
          }
          indexs.push(item.id);
          b = true;
          break;
        }
      }

      if (!b) {
        fields[item.id] = {
          "uid": item.uid,
          "dataType": item.fieldType ? item.fieldType : "VARCHAR",
          "type": item.requestType ? item.requestType : "string",
          "notNull": item.requestNotNull ? true : false,
          "length": item.length,
          "precision": item.precision,
          "scale": item.scale,
          "comment": item.title ? item.title : "",
          "version": 1,
          "status": 0,
          "oldVersion": 0
        }
        indexs.push(item.id);
        bb = true;
      }
    }
  }

  for (let b = 0; b < standardFields1.length; b++) {
    var f = standardFields1[b];
    fields[f] = oldFields[f];
    if (option.mode != "create") {
      fields[f].oldVersion = fields[f].version;
    }
    indexs.push(f);
  }
  json.fields = fields;
  json.indexs = indexs;

  if (option.mode == "create") {
    json.version = 1;
  }
  else {
    if (json.oldVersion == null) json.oldVersion = json.version;
    if (bb) {
      json.version = json.version + 1;
    }
  }

  if (!this.connection) this.connection = new Connection(server.config.Database);
  if (!this.dao) this.dao = new Dao(this.service);
  var sqlList = this.connection.getDDL(json);
  this.dao.exeSqls(sqlList, 0, function () {
    cb(json);
  });
};

/**
 * 转换model
 * @param {*} option 参数
 * @param {object} option.info 信息
 * @param {object} option.models 模型
 * @param {object} option.items 元素 //
 * @param {*} cb 
 */
TdfManagerBl.prototype.transformModels = function (option, cb) {
  var self = this;
  this.tmp_json = {};
  this.tmp_items = [];
  for (var m in option.items) {
    if (m != "main") {
      this.tmp_items.push(m);
    }
  }

  var mode = "";
  if (option.models[option.info.tableName] == null || option.mode == 'create') {
    mode = "create";
    option.models[option.info.tableName] = {
      "tdm": self.defaultTDM({
        "info": option.info
      })
    };
  }

  self.transformTDM({
    "tdm": option.models[option.info.tableName].tdm,
    "fields": option.items.main,
    "mode": mode
  }, function (json) {
    self.tmp_json[option.info.tableName] = {
      "type": "table",
      "tdf": {},
      "tdm": json
    }

    self.tmp_items_index = 0;
    self.transformModelsLoop(option, cb);
  });
};

/**
 * 
 * @param {*} option 
 * @param {*} cb 
 */
TdfManagerBl.prototype.transformModelsLoop = function (option, cb) {

  var self = this;
  if (self.tmp_items_index == self.tmp_items.length) {
    cb(self.tmp_json);
  }
  else {
    var subItems = option.items[self.tmp_items[self.tmp_items_index]];
    var subTableName = option.info.tableName + "_" + subItems.id;

    var mode = "";
    if (option.models[subTableName] == null || option.mode == 'create') {
      mode = "create";
      option.models[subTableName] = {
        "tdm": self.defaultTDM({
          "info": option.info,
          "other": { "subTableName": subItems.id }
        })
      };
    }

    self.transformTDM({
      "tdm": option.models[subTableName].tdm,
      "fields": subItems.fields,
      "mode": mode
    }, function (json) {
      self.tmp_json[subTableName] = {
        "type": "table",
        "tdf": {},
        "tdm": json
      }
      self.tmp_items_index++;
      self.transformModelsLoop(option, cb);
    });
  }
};

/**
 * 转换信息
 * @param {object} option 参数
 * @param {object} option.info 默认
 * @param {string} option.filePath 路径
 * @returns object { filePath 路径 projName 项目 dataPath 目录 dataName 名称 tableName 模型} 
 */
TdfManagerBl.prototype.transformInfo = function (option) {
  if (!option.info) option.info = {};
  var json = Object.assign(option.info, option.param);

  if (option.filePath) {
    json.filePath = option.filePath.replace("/app", "");
    var tt = option.filePath.replace("/app/", "");
    json.projName = tt.substring(0, tt.indexOf('/tdf'));
    tt = tt.substring(tt.indexOf('/tdf') + 5)
    json.dataPath = tt.substring(0, tt.lastIndexOf('/'));
    json.dataName = tt.substring(tt.lastIndexOf('/') + 1).replace(".tdf", "");
    if (json.dataPath)
      json.tableName = (json.dataPath + '/' + json.dataName).replaceAll('/', "_");
    else
      json.tableName = json.dataName;
  }

  return json;
};

/**
 * 默认TDF
 * @param {object} option 参数
 * @param {string} option.filePath 路径
 * @param {object} option.viewParam 页面参数
 * @param {object} option.serviceParam 后台参数
 * @param {object} option.modelParam 模型参数
 * @returns object { info 信息 items 元素 views 页面 services 服务 models 模型} 
 */
TdfManagerBl.prototype.defaultTDF = function (option) {
  var tdf = {
    "framework": "tdf",
    "info": {
      "createTime": new Date,
      "dataId": uuid.v1().replace(/-/g, ''),
      "dataName": "",
      "dataPath": "",
      "projName": "",
      "filePath": "",
      "viewParam": option.viewParam,
      "serviceParam": option.serviceParam,
      "modelParam": option.modelParam
    },
    "items": {
      "main": []
      // "fields":[]
    },
    "tabs": {
      "enable": false,
      "default": "",
      "pages": [{
        "code": "list",
        "name": "",
        "param": {
          "autoFields": true,
          "isCreate": true,
          "isDelete": true,
        },
        "query": [],
        "fields": []
      }],
    },
    "phoneEdit": {
      "param": {
        "autoFields": true
      },
      "fields": []
    },
    "phoneTabs": {
      "enable": false,
      "default": "",
      "pages": [{
        "code": "mList",
        "name": "",
        "param": {
          "selectTable": "main",
          "autoFields": true,
          "isCreate": true,
          "isDelete": true,
          "enableDataPage": true,
          "layout": "1"
        },
        "query": [],
        "fields": []
      }],
    },
    "views": {
      "index": {
        "type": "tab",
        "tdf": {},
        "tfp": {}
      },
      "list": {
        "type": "index",
        "tdf": {},
        "tfp": {}
      },
      "edit": {
        "type": "edit",
        "tdf": {},
        "tfp": {}
      },
      "mEdit": {
        "type": "mEdit",
        "tdf": {},
        "tfp": {}
      },
      "mIndex": {
        "type": "mIndex",
        "tdf": {},
        "tfp": {}
      },
      "mList": {
        "type": "mList",
        "tdf": {},
        "tfp": {}
      }
    },
    "services": {
      "save": {
        "type": "save",
        "tdf": {},
        "tbs": {}
      },
      "get": {
        "type": "get",
        "tdf": {},
        "tbs": {}
      },
      "remove": {
        "type": "remove",
        "tdf": {},
        "tbs": {}
      },
      "list": {
        "type": "list",
        "tdf": {},
        "tbs": {}
      },
      "mList": {
        "type": "mList",
        "tdf": {},
        "tbs": {}
      }
    },
    "models": {}
  }

  if (option.filePath) {
    tdf.info.filePath = option.filePath.replace("/app", "");
    var tt = option.filePath.replace("/app/", "");
    tdf.info.projName = tt.substring(0, tt.indexOf('/tdf'));
    tt = tt.substring(tt.indexOf('/tdf') + 5)
    tdf.info.dataPath = tt.substring(0, tt.lastIndexOf('/'));
    tdf.info.dataName = tt.substring(tt.lastIndexOf('/') + 1).replace(".tdf", "");
    if (tdf.info.dataPath)
      tdf.info.tableName = (tdf.info.dataPath + '/' + tdf.info.dataName).replaceAll('/', "_");
    else
      tdf.info.tableName = tdf.info.dataName;

    tdf.models[tdf.info.tableName] = {
      "type": "table",
      "tdf": {},
      "tdm": {}
    };
  }

  return tdf;
};

/**
 * 默认TFP
 * @param {object} option 参数
 * @param {string} option.type 类型(edit|index)
 * @param {object} option.info 信息
 * @returns 
 */
TdfManagerBl.prototype.defaultTFP = function (option) {
  var tfp = {};
  if (option.type == "edit") {
    tfp = {
      "client": option.info.viewParam.client, // "pc",
      "mobileType": option.info.viewParam.mobileType, //"H5",
      "framework": option.info.viewParam.framework, //"tfp",
      "positionType": option.info.viewParam.positionType, //"float",
      "pageType": option.info.viewParam.pageType, //"page",
      "bgColorMode": option.info.viewParam.bgColorMode, //"light",
      "title": option.info.viewParam.title, // "",
      "type": "Page",
      "projName": option.info.projName,
      "tableName": option.info.tableName,
      "components": [
        {
          "id": "panelMain",
          "type": "Panel",
          "class": "tfp-panel-main",
          "components": [
            {
              "id": "panelBoard",
              "type": "Panel",
              "class": "tfp-panel-board",
              "components": [
                {
                  "id": "panelAfter",
                  "type": "Panel",
                  "class": "tfp-panel-after",
                  "components": [
                    {
                      "id": "panelBefore",
                      "type": "Panel",
                      "class": "tfp-panel-before",
                      "components": [
                        {
                          "type": "Form",
                          "id": "form1",
                          "components": [
                            {
                              "type": "Gridbox",
                              "id": "gridbox1",
                              "components": [
                                {
                                  "type": "Panel",
                                  "id": "panelTitle",
                                  "styles": {
                                    "width": "100%",
                                    "height": "40px",
                                    "padding": "4px 4px",
                                    "display": "none"
                                  },
                                  "components": [
                                    // {
                                    //   "type": "Label",
                                    //   "id": "labelTitle",
                                    //   "value": "",
                                    //   "size": "title3"
                                    // },
                                    // {
                                    //   "type": "Button",
                                    //   "id": "buttonSave",
                                    //   "value": "保存",
                                    //   "styles": {
                                    //     "float": "right"
                                    //   },
                                    //   "buttonType": "primary",
                                    //   "theme": "round",
                                    //   "onClick": "form1.submit()"
                                    // }
                                  ]
                                }
                              ]
                            }
                          ],
                          "loadDataService": "serviceGet",
                          "submitService": "serviceSave",
                          "dataBindingMember": "data"
                        }
                      ],
                      "styles": {

                      }
                    }
                  ],
                  "styles": {

                  }
                }
              ],
              "styles": {

              }
            }
          ],
          "styles": {

          }
        },
        {
          "type": "Service",
          "id": "serviceGet",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.get.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'get' },
          "argSettings": [
            {
              "name": "id",
              "type": "QueryString",
              "value": "id"
            }
          ],
          "bindComponents": [
            "form1"
          ]
        },
        {
          "type": "Service",
          "id": "serviceSave",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.save.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'save' },
          "argSettings": [
            {
              "name": "id",
              "type": "QueryString",
              "value": "id"
            }
          ],
          "onResponse": "serviceSave_onResponse(req, res)",
          "bindComponents": [
            "form1"
          ],
          // "onResponse": "serviceSave_onResponse(req, res)"
        },
        {
          "type": "Service",
          "id": "serviceOther",
          "autoShowError": true,
          "path": "",
          "argSettings": [
          ],
          "bindComponents": [
          ]
        }

      ],
      "jsFuncs": [
        {
          "name": "page1_onLoad",
          "comment": "页面加载后",
          "editType": "code",
          "args": [],
          "code": "\n    $('body').on('change', '.uniqueVerify', function () {\r\n        if (!this.value) return false;\r\n        const isDataset = $(this).parents('.tfp-dataset').length > 0;\r\n        let tableName = tfp.curPage.dataModel.tableName;\r\n        if (isDataset) tableName += ('_' + $(this).parents('.tfp-dataset').eq(0).attr('id'));\r\n        let field = this.id;\r\n        if (isDataset) field = this.dataset.id;\r\n       changeInput = this;\r\n        const args = {\r\n            \"tableName\": tableName,\r\n            \"field\": field,\r\n            \"value\": this.value,\r\n            \"excludeField\": \"id\",\r\n            \"excludeValue\": getUrlArg('id'),\r\n            \"where\": \"tb_status=0\"\r\n        }\r\n        tfp.use([\"Service\"], function () {\r\n            let service = tfp.new(\"Service\");\r\n            service.path = \"/sys/service/common/uniqueVerify.js\";\r\n            service.dataModel.autoShowError = false;\r\n            service.dataModel.onError = \"(function(msg) { alert(msg);changeInput.value=''; })(msg)\";\r\n            service.request(args);\r\n        });\r\n    });\r\n"
        },
        {
          "name": "serviceSave_onResponse",
          "comment": "服务响应时",
          "editType": "code",
          "args": [
            {
              "name": "req",
              "type": "Object",
              "comment": "请求参数"
            },
            {
              "name": "res",
              "type": "Object",
              "comment": "响应参数"
            }
          ],
          // "code": "\n    var curPath = tfp.curPage.dataModel.curPath;\r\n    var gotoPage = curPath.substring(curPath.lastIndexOf('/')+1).replace('edit','index');\r\n    tfp.gotoPage(gotoPage);\r\n"
          "code": `
            tfp.getCurDrawer().opener.grid1.reloadData();
            tfp.closeDrawer();
          `
        }
      ],
      "id": "page1",
      "onLoad": "page1_onLoad()",
      "jsGlobalVars": [
        {
          "name": "changeInput",
          "type": "null",
          "value": ""
        }
      ]
    }
  }
  else if (option.type == "index") {
    tfp = {
      "client": option.info.viewParam.client, // "pc",
      "mobileType": option.info.viewParam.mobileType, //"H5",
      "framework": option.info.viewParam.framework, //"tfp",
      "positionType": option.info.viewParam.positionType, //"float",
      "pageType": option.info.viewParam.pageType, //"page",
      "bgColorMode": option.info.viewParam.bgColorMode, //"light",
      "title": option.info.viewParam.title, // "",
      "type": "Page",
      "projName": option.info.projName,
      "tableName": option.info.tableName,
      "components": [
        {
          "id": "panelPage",
          "type": "Panel",
          "components": [
            {
              "id": "panelHeader",
              "type": "FlexPanel",
              "styles": {
                "left": "20px",
                "top": "20px",
                "right": "20px",
                "height": "50px",
                "position": "absolute",
                "background-color": "#f6f6ff",
                "overflow": "auto",
                "display": "flex",
                "flex-wrap": "wrap",
                // "align-items": "center",
                "border-radius": "6px 6px 6px 6px"
              },
              "components": [
                {
                  "type": "FlexPanel",
                  "id": "panelToolbar",
                  "styles": {
                    "height": "50px",
                    "font-size": "0",
                    "flex-grow": "0",
                    "flex-shrink": "0",
                    "flex-basis": "auto",
                    "margin": "0px",
                    "display": "flex",
                    "flex-wrap": "wrap",
                    "align-items": "center",
                  },
                  "components": [
                    {
                      "id": "button_add",
                      "type": "Button",
                      "buttonType": "primary",
                      "theme": "round",
                      "value": "添加",
                      "styles": {
                        "display": "inline-block",
                        "flex-grow": 0,
                        "flex-shrink": 0,
                        "flex-basis": "60px",
                        "margin-left": "10px",
                        "cursor": "pointer",
                        "padding-left": "10px",
                        "padding-right": "10px",
                        "text-align": "center",
                        "margin": "10px 0px 10px 10px"
                      },
                      "onClick": "button_add_onClick()"
                    }
                  ]
                },
                {
                  "type": "FlexPanel",
                  "id": "panelQuery",
                  "styles": {
                    "height": "50px",
                    "font-size": "0",
                    "flex-grow": "0",
                    "flex-shrink": "0",
                    "flex-basis": "auto",
                    "margin": "0px 0px 0px 10px",
                    "display": "flex",
                    "flex-wrap": "wrap",
                    "align-items": "center",
                    "flex": "1 1"
                  },
                  "components": [
                    {
                      "type": "Button",
                      "id": "buttonQuery",
                      "value": "搜索",
                      "labelSize": 14,
                      "labelHeight": "30",
                      "imageWidth": 24,
                      "imageHeight": 24,
                      "theme": "round",
                      "styles": {
                        "cursor": "pointer",
                        "padding-left": "10px",
                        "padding-right": "10px",
                        "text-align": "center",
                        "flex-grow": "0",
                        "flex-shrink": "0",
                        "flex-basis": "auto",
                        "margin-left": "10px",
                        "display": "none",
                        "user-select": "none",
                      },
                      "onClick": "button_query_onClick()"
                    },
                    {
                      "type": "Label",
                      "id": "spreadLabel",
                      "value": '展开',
                      "styles": {
                        "display": "none",
                        "float": "left",
                        "cursor": "pointer",
                        "user-select": "none",
                      },
                      "onClick": "spreadLabel_onClick()"
                    }
                  ]
                }
              ]
            },
            {
              "id": "grid1",
              "type": "GridView",
              "showHeader": true,
              "showFooter": true,
              "showBorder": true,
              "loadDataService": "serviceGetList",
              "dataBindingMember": "data",
              "doubleRowBgColor": "#f6f6ff",
              "styles": {
                "position": "absolute",
                "left": "20px",
                "right": "20px",
                "bottom": "20px",
                "top": "80px"
              },
              "columns": [
                // {
                //   "align": "center",
                //   "format": "修改",
                //   "name": "修改",
                //   "onClick": "button_edit_onClick('{id}')",
                //   "width": "70px",
                //   "contentType": "button",
                //   "buttonTheme": "round",
                //   "buttonBgColor": "#0099FF",
                //   "buttonFontColor": "#FFFFFF"
                // },
                // {
                //   "align": "center",
                //   "format": "删除",
                //   "name": "删除",
                //   "onClick": "grid1.deleteRow({id})",
                //   "width": "70px",
                //   "contentType": "button",
                //   "buttonTheme": "round",
                //   "buttonBgColor": "#FF6600",
                //   "buttonFontColor": "#FFFFFF"
                // }
              ],
              "dataBindingKey": "id",
              "delDataService": "serviceDelete",
              "allowPaging": true,
              "pageSize": 20,
              "onCellClick": "grid1_onCellClick(rowIndex, colIndex, rowData, this)"
            }
          ],
          "styles": {
            "left": "0px",
            "top": "0px",
            "right": "0px",
            "bottom": "0px",
            "position": "absolute",
            "border-radius": " 6px 6px 6px 6px",
            "border-color": "#CCCCCC",
            "border-width": "0",
            "box-shadow": " 3px 5px 5px #cccccc",
            "min-width": "780px",
            "overflow": "auto",
            "background-color": "#FFFFFF"
          }
        },
        {
          "id": "serviceGetList",
          "type": "Service",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.list.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'list' },
          "argSettings": []
        },
        {
          "id": "serviceDelete",
          "type": "Service",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.remove.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'remove' },
          "argSettings": []
        }
      ],
      "jsFuncs": [
        {
          "name": "page1_onLoad",
          "comment": "页面加载后",
          "editType": "code",
          "args": [],
          "code": `
            panelHeader.css('overflow-y', 'hidden');
            if(panelHeader.el.scrollHeight == panelHeader.el.offsetHeight) return false;
            panelHeader.css('padding-right', '100px');
            buttonQuery.css('position', 'absolute');
            buttonQuery.css('right', '50px');
            spreadLabel.show();
            spreadLabel.css('position', 'absolute');
            spreadLabel.css('right', '10px');
          `
        },
        {
          "name": "spreadLabel_onClick",
          "comment": "点击时",
          "editType": "code",
          "args": [],
          "code": `
            if(spreadLabel._jqObj.text() == '展开') {
              grid1.css('top', (80 + (panelHeader.el.scrollHeight - panelHeader.el.offsetHeight)) + 'px');
              panelHeader._jqObj.height(panelQuery.el.scrollHeight);
              spreadLabel._jqObj.html('收起');
            }
            else {
              panelHeader._jqObj.height(50);
              grid1.css('top', '80px');
              spreadLabel._jqObj.html('展开');
            }
          `
        },
        {
          "name": "button_add_onClick",
          "comment": "点击添加按钮时",
          "editType": "code",
          "args": [],
          // "code": "  var curPath = tfp.curPage.dataModel.curPath;\n  var gotoPage = curPath.substring(curPath.lastIndexOf('/')+1).replace(/index\\d+/,'edit');\n  tfp.gotoPage(gotoPage);\n",
          "code": `
            var curPath = tfp.curPage.dataModel.curPath;
            tfp.openDrawer("新建", '${this.getTdfViewPath(option.info, 'edit')}', '', function(drawer) {
              drawer.form1.submit();
            });
          `
        },
        {
          "name": "button_edit_onClick",
          "comment": "点击修改按钮时",
          "editType": "code",
          "args": [
            {
              "name": "id",
              "type": "string"
            }
          ],
          // "code": "  var curPath = tfp.curPage.dataModel.curPath;\n  var gotoPage = curPath.substring(curPath.lastIndexOf('/')+1).replace(/index\\d+/,'edit');\n  tfp.gotoPage(gotoPage+'?id='+id);\n"
          "code": `
            var curPath = tfp.curPage.dataModel.curPath;
            tfp.openDrawer("修改", '${this.getTdfViewPath(option.info, 'edit')}?id=' + id, '', function(drawer) {
              drawer.form1.submit();
            });
          `
        },
        {
          "name": "button_query_onClick",
          "comment": "点击时",
          "editType": "code",
          "args": [],
          "code": "\n  grid1.reloadData(); \r\n"
        },
        {
          "name": "grid1_onCellClick",
          "comment": "单击单元格时",
          "editType": "code",
          "args": [
            {
              "name": "rowIndex",
              "type": "Int",
              "comment": "行索引"
            },
            {
              "name": "colIndex",
              "type": "Int",
              "comment": "列索引"
            },
            {
              "name": "rowData",
              "type": "Object",
              "comment": "当前行数据"
            },
            {
              "name": "elem",
              "type": "Object",
              "comment": "dom对象"
            }
          ],
          "code": `if(!$(elem).hasClass('no-open-update-drawer')) button_edit_onClick(rowData.id);`
        }
      ],
      "id": "page1",
      "onLoad": "page1_onLoad()"
    }
  }
  else if (option.type == "tab") {
    const indexPage = option.info.viewParam.client == 'pc' ? 'index' : 'mIndex';
    tfp = {
      "client": option.info.viewParam.client, // "pc",
      "mobileType": option.info.viewParam.mobileType, //"H5",
      "framework": option.info.viewParam.framework, //"tfp",
      "positionType": option.info.viewParam.positionType, //"float",
      "pageType": option.info.viewParam.pageType, //"page",
      "bgColorMode": option.info.viewParam.bgColorMode, //"light",
      "title": option.info.viewParam.title, // "",
      "type": "Page",
      "projName": option.info.projName,
      "tableName": option.info.tableName,
      "components": [
        {
          "type": "Tab",
          "id": "tab1",
          "pageIndex": 0,
          "titleWidth": 150,
          "titleHeight": 40,
          "position": "top",
          "styles": {
            "width": "100%",
            "height": "100%",
            "position": "relative",
            "left": 0,
            "top": 0,
            "display": "none"
          },
          "components": [],
          "onAfterInitRuntime": "tab1_onAfterInitRuntime()",
          "onTabIndexChange": "tab1_onTabIndexChange()"
        },
        {
          "type": "Iframe",
          "id": "iframe",
          "frameBorder": 0,
          "marginWidth": 0,
          "marginHeight": 0,
          "styles": {
            "position": "relative",
            "left": 0,
            "top": 0,
            "width": "100%",
            "height": "100%",
            "border-color": "#CCCCCC",
            "border-width": "1px",
            "border-style": "solid",
            "background-color": "#FFFFFF"
          },
          "src": "",
          "onAfterInitRuntime": "iframe_onAfterInitRuntime()"
        }
      ],
      "id": "page1",
      "onLoad": "page1_onLoad()",
      "jsFuncs": [
        {
          "name": "page1_onLoad",
          "comment": "页面加载后",
          "editType": "code",
          "args": [],
          "code": `
            if(window.location.href == top.location.href) {
              tfp.dynamicLoadJs('/app/sys/console/console.js');
              tfp.dynamicLoadCss('/app/sys/console/console.css');
            }
          `
        },
        {
          "name": "tab1_onAfterInitRuntime",
          "comment": "组件初始化后",
          "editType": "code",
          "args": [],
          "code": `
  const _iframe = tfp.components['iframe0']; 
  if(_iframe && _iframe.css('display')!='none') _iframe.attr('src', location.pathname.substring(location.pathname.lastIndexOf('/')+1).replace('${indexPage}', tab1.pages[0].id));
          `
        },
        {
          "name": "tab1_onTabIndexChange",
          "comment": "选中页变化时",
          "editType": "code",
          "args": [],
          "code": `
  const _iframe = tfp.components['iframe'+tab1.pageIndex];
  if(!_iframe.attr('src')) _iframe.attr('src', location.pathname.substring(location.pathname.lastIndexOf('/')+1).replace('${indexPage}',tab1.pages[tab1.pageIndex].id));
  else _iframe._jqObj[0].contentWindow.grid1.reloadData();
          `
        },
        {
          "name": "iframe_onAfterInitRuntime",
          "comment": "组件初始化后",
          "editType": "code",
          "args": [],
          "code": `
  if(iframe.css('display')!='none') iframe.attr('src', location.pathname.substring(location.pathname.lastIndexOf('/')+1).replace('${indexPage}',tab1.pages[0].id));
          `
        }
      ]
    }
    if (option.info.viewParam.client == 'phone') {
      tfp.client = 'phone';
      tfp.mobileType = 'TaskMsg';
    }
  }
  else if (option.type == "mEdit") {
    tfp = {
      "client": "phone",
      "mobileType": "TaskMsg",
      "framework": option.info.viewParam.framework, //"tfp",
      "positionType": option.info.viewParam.positionType, //"float",
      "pageType": option.info.viewParam.pageType, //"page",
      "bgColorMode": option.info.viewParam.bgColorMode, //"light",
      "title": option.info.viewParam.title, // "",
      "type": "Page",
      "projName": option.info.projName,
      "tableName": option.info.tableName,
      "components": [
        {
          "type": "Form",
          "id": "form1",
          "styles": {},
          "components": [],
          "loadDataService": "serviceGet",
          "dataBindingMember": "data",
          "submitService": "serviceSave",
          "showSubmitSuccessHint": true,
          "onAfterSubmit": "form1_onAfterSubmit(res)"
        },
        {
          "type": "Service",
          "id": "serviceGet",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.get.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'get' },
          "argSettings": [
            {
              "name": "id",
              "type": "QueryString",
              "value": "id"
            }
          ],
          "bindComponents": [
            "form1"
          ]
        },
        {
          "type": "Service",
          "id": "serviceSave",
          "autoShowError": true,
          // "path": option.info.filePath.replace('.tdf', '.service.save.tdf'),
          "pathArgs": { "opType": 'service', "opName": 'save' },
          "argSettings": [
            {
              "name": "id",
              "type": "QueryString",
              "value": "id"
            }
          ],
          "bindComponents": [
            "form1"
          ],
          // "onResponse": "serviceSave_onResponse(req, res)"
        },
        {
          "type": "Service",
          "id": "serviceOther",
          "autoShowError": true,
          "path": "",
          "argSettings": [
          ],
          "bindComponents": [
          ]
        }

      ],
      "jsFuncs": [
        {
          "name": "page1_onLoad",
          "comment": "页面加载后",
          "editType": "gui",
          "args": [],
          "statements": [
            {
              "category": "extend",
              "type": "setToolBtn",
              "text": "保存",
              "jsStatement": "submitForm();"
            },
            {
              "category": "common",
              "type": "custom",
              "content": `top.submitForm = function () { form1.submit(); };`
            },
          ]
        },
        {
          "name": "form1_onAfterSubmit",
          "comment": "提交后",
          "editType": "gui",
          "args": [
            {
              "name": "res",
              "comment": "响应",
              "type": "Object"
            }
          ],
          "statements": [
            {
              "category": "extend",
              "type": "invokeOpenerCallbackFunc",
              "arg": "res"
            }
          ]
        }
      ],
      "id": "page1",
      "onLoad": "page1_onLoad()",
      "jsGlobalVars": [
        {
          "name": "changeInput",
          "type": "null",
          "value": ""
        }
      ]
    }
  }
  else if (option.type == "mList") {
    tfp = {
      "client": "phone",
      "mobileType": "TaskMsg",
      "framework": option.info.viewParam.framework, //"tfp",
      "positionType": option.info.viewParam.positionType, //"float",
      "pageType": option.info.viewParam.pageType, //"page",
      "bgColorMode": option.info.viewParam.bgColorMode, //"light",
      "title": option.info.viewParam.title, // "",
      "type": "Page",
      "projName": option.info.projName,
      "tableName": option.info.tableName,
      "components": [
        {
          "type": "Grid",
          "id": "grid1",
          "showSearchBox": false,
          "allowPaging": true,
          "styles": {
            "position": "absolute",
            "left": 0,
            "top": 10,
            "right": 0,
            "bottom": 10,
            "width": "100%"
          },
          "components": [
            {
              "id": "grid1_DataRow",
              "type": "GridDataRow",
              "styles": {
                "position": "absolute",
                "top": "0",
                "left": "10px",
                "right": "10px",
                "border": "1px solid #cccccc",
                "border-radius": "10px"
              },
              "components": [],
              "height": "130"
            }
          ],
          "loadDataService": "serviceGetList",
          "dataBindingMember": "data",
          // "dataBindingKey": "spbh" // 搜索
        },
        {
          "id": "serviceGetList",
          "type": "Service",
          "autoShowError": true,
          "pathArgs": { "opType": 'service', "opName": 'list0' },
          "argSettings": []
        },
        {
          "id": "serviceDelete",
          "type": "Service",
          "autoShowError": true,
          "pathArgs": { "opType": 'service', "opName": 'remove' },
          "argSettings": []
        }
      ],
      "id": "page1",
      "onLoad": "page1_onLoad()",
      "jsFuncs": [
        {
          "name": "page1_onLoad",
          "comment": "页面加载后",
          "editType": "gui",
          "args": [],
          "statements": [
            {
              "category": "extend",
              "type": "setToolBtn",
              "text": "添加",
              "jsStatement": "gotoMEditPage()"
            },
            {
              "category": "common",
              "type": "custom",
              "content": `top.gotoMEditPage = gotoMEditPage;`
            },
          ]
        },
        {
          "name": "gotoMEditPage",
          "comment": "前往编辑页面",
          "editType": "gui",
          "args": [
            {
              "name": "id",
              "type": "Number",
              "comment": "编号"
            }
          ],
          "statements": [
            {
              "category": "common",
              "type": "declare",
              "varName": "url",
              "varType": "string",
              "defaultVal": `'${this.getTdfViewPath(option.info, 'mEdit')}'`
            },
            {
              "category": "common",
              "type": "if",
              "condition": "id",
              "statements": [
                {
                  "category": "framework",
                  "type": "tfp.addUrlArg",
                  "retVarName": "url",
                  "argName": "id",
                  "argVal": "id",
                  "url": "url"
                }
              ]
            },
            {
              "category": "extend",
              "type": "openWebPage",
              "hideNavBar": "false",
              "cbArg": "",
              "url": "url",
              "title": "id ? '修改' : '添加'",
              "statements": [
                {
                  "category": "common",
                  "type": "custom",
                  "content": "grid1.reloadData();"
                }
              ]
            }
          ]
        },
        {
          "name": "deleteRow",
          "comment": "",
          "editType": "code",
          "args": [
            {
              "name": "id",
              "type": "int",
              "required": false
            }
          ],
          "code": "if(!confirm(\"确定删除？\")) return;\n   serviceDelete.request({id: id}, function(req, res) {\n    grid1.reloadData();\n  });\n"
        }
      ],
      "styleSheets": [
        {
          "id": ".tfp-griddatarow",
          "styles": [
            {
              "name": "display",
              "value": "flex"
            },
            {
              "name": "flex-wrap",
              "value": "wrap"
            }
          ]
        },
        {
          "id": ".tfp-griddatarow-template",
          "styles": [
            {
              "name": "display",
              "value": "flex"
            },
            {
              "name": "flex-wrap",
              "value": "wrap"
            },
            {
              "name": "visibility",
              "value": "hidden"
            }
          ]
        }
      ]
    }
  }
  return tfp;
};

/**
 * 默认TBS
 * @param {object} option 参数
 * @param {string} option.type 类型(save|get|list|remove)
 * @param {object} option.info 信息 tableName filePath
 * @returns 
 */
TdfManagerBl.prototype.defaultTBS = function (option) {
  var tbs = {};
  if (option.type == "save") {
    tbs = {
      "name": "Save",
      "comment": "保存",
      "reqArgs": [
      ],
      "retArgs": [
        {
          "name": "id",
          "type": "int"
        }
      ],
      "methods": [
        {
          "name": "process",
          "comment": "处理服务请求",
          "args": [
            {
              "name": "req",
              "type": "object",
              "comment": "服务请求对象"
            },
            {
              "name": "res",
              "type": "object",
              "comment": "服务响应对象"
            }
          ],
          "statements": [
            // {
            //   "category": "common",
            //   "type": "declare",
            //   "varName": "returnId",
            //   "varType": "null"
            // },
            {
              "category": "common",
              "type": "if",
              "condition": "req.id",
              "statements": [
                // {
                //   "category": "db",
                //   "type": "update",
                //   "model": {
                //     "name": option.info.tableName,
                //     "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf')
                //   },
                //   "where": "id=${req.id}",
                //   "fields": [
                //     {
                //       "name": "tb_status",
                //       "value": "0"
                //     },
                //     {
                //       "name": "tb_utime",
                //       "value": "new Date()"
                //     },
                //     {
                //       "name": "tb_uuserid",
                //       "value": "req.session.userId"
                //     }
                //   ],
                //   "statements": [
                //     {
                //       "category": "common",
                //       "type": "assign",
                //       "operator": "=",
                //       "varName": "res.id",
                //       "value": "req.id"
                //     },
                //     {
                //       "category": "common",
                //       "type": "end"
                //     }
                //   ]
                // }
              ],
              "elseStatements": [
                // {
                //   "category": "db",
                //   "type": "insert",
                //   "model": {
                //     "name": option.info.tableName,
                //     "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf')
                //   },
                //   "fields": [
                //     {
                //       "name": "tb_status",
                //       "value": "0"
                //     },
                //     {
                //       "name": "tb_ctime",
                //       "value": "new Date()"
                //     },
                //     {
                //       "name": "tb_cuserid",
                //       "value": "req.session.userId"
                //     }
                //   ],
                //   "cbArg": "ret",
                //   "statements": [
                //     {
                //       "category": "common",
                //       "type": "assign",
                //       "varName": "res.id",
                //       "operator": "=",
                //       "value": "ret.insertId"
                //     },
                //     {
                //       "category": "common",
                //       "type": "end"
                //     }
                //   ]
                // }
              ]
            }
          ]
        }
      ],
      "notCheckLogin": false,
      "notCheckAuthority": false,
      "notCheckSQLInject": false,
      "resArgs": []
    };
  }
  else if (option.type == "get") {
    tbs = {
      "name": "Get",
      "comment": "查询",
      "reqArgs": [
        {
          "name": "id",
          "type": "int"
        }
      ],
      "retArgs": [
        {
          "name": "data",
          "type": "array"
        }
      ],
      "methods": [
        {
          "name": "process",
          "comment": "处理服务请求",
          "args": [
            {
              "name": "req",
              "type": "object",
              "comment": "服务请求对象"
            },
            {
              "name": "res",
              "type": "object",
              "comment": "服务响应对象"
            }
          ],
          "statements": [
            {
              "category": "common",
              "type": "if",
              "condition": "req.id",
              "statements": [
                // {
                //   "category": "db",
                //   "type": "query",
                //   "model": {
                //     "name": option.info.tableName,
                //     "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf')
                //   },
                //   "fields": [
                //     {
                //       "name": "id"
                //     },
                //     {
                //       "name": "tb_status"
                //     },
                //     {
                //       "name": "tb_ctime"
                //     },
                //     {
                //       "name": "tb_cuserid"
                //     },
                //     {
                //       "name": "tb_utime"
                //     },
                //     {
                //       "name": "tb_uuserid"
                //     },
                //     {
                //       "name": "tb_dtime"
                //     },
                //     {
                //       "name": "tb_duserid"
                //     },
                //     {
                //       "name": "tb_rid"
                //     },
                //     {
                //       "name": "tb_info"
                //     }
                //   ],
                //   "cbArg": "rows",
                //   "orders": [],
                //   "groups": [],
                //   "where": "",
                //   "pageSize": 20,
                //   "enableDataPage": false,
                //   "count": 1,
                //   "distinct": false,
                //   "queryArgs": [
                //     {
                //       "name": "id",
                //       "comment": "id",
                //       "condition": "id={req.id}"
                //     }
                //   ],
                //   "statements": [
                //     {
                //       "category": "common",
                //       "type": "assign",
                //       "varName": "res.data",
                //       "operator": "=",
                //       "value": "rows[0]"
                //     },
                //     {
                //       "category": "common",
                //       "type": "end"
                //     }
                //   ]
                // }
              ],
              "elseStatements": [
                {
                  "category": "common",
                  "type": "assign",
                  "varName": "res.data",
                  "operator": "=",
                  "value": "{}"
                },
                {
                  "category": "common",
                  "type": "end"
                }
              ]
            }
          ]
        }
      ],
      "notCheckLogin": false,
      "notCheckAuthority": false,
      "notCheckSQLInject": false,
      "resArgs": []
    };
  }
  else if (option.type == "list") {
    tbs = {
      "name": "List",
      "comment": "列表",
      "reqArgs": [

      ],
      "retArgs": [
        {
          "name": "data",
          "type": "对象"
        }
      ],
      "methods": [
        {
          "name": "process",
          "comment": "处理服务请求",
          "args": [
            {
              "name": "req",
              "type": "object",
              "comment": "服务请求对象"
            },
            {
              "name": "res",
              "type": "object",
              "comment": "服务响应对象"
            }
          ],
          "statements": []
        }
      ],
      "notCheckLogin": false,
      "notCheckAuthority": false,
      "notCheckSQLInject": false,
      "resArgs": []
    };
  }
  else if (option.type == "remove") {
    tbs = {
      "name": "Remove",
      "comment": "删除",
      "reqArgs": [
        {
          "name": "id",
          "type": "int",
          "notNull": true
        }
      ],
      "methods": [
        {
          "name": "process",
          "comment": "处理服务请求",
          "args": [
            {
              "name": "req",
              "type": "object",
              "comment": "服务请求对象"
            },
            {
              "name": "res",
              "type": "object",
              "comment": "服务响应对象"
            }
          ],
          "statements": [
            // {
            //   "category": "db",
            //   "type": "update",
            //   "model": {
            //     "name": option.info.tableName,
            //     "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf')
            //   },
            //   "fields": [
            //     {
            //       "name": "tb_status",
            //       "value": "1"
            //     },
            //     {
            //       "name": "tb_dtime",
            //       "value": "new Date()"
            //     },
            //     {
            //       "name": "tb_duserid",
            //       "value": "req.session.userId"
            //     }
            //   ],
            //   "where": "id=${req.id}",
            //   "statements": [
            //     {
            //       "category": "common",
            //       "type": "end"
            //     }
            //   ]
            // }
          ]
        }
      ],
      "notCheckLogin": false,
      "notCheckAuthority": false,
      "notCheckSQLInject": false,
      "resArgs": []
    };
  }
  return tbs;
};

/**
 * 
 * @param {*} option 
 * @returns 
 */
TdfManagerBl.prototype.defaultTBSMain = function (option) {
  var statements = {};

  if (option.type == "save") {
    if (option.other.type == "update") {
      statements = {
        "category": "db",
        "type": "update",
        "model": {
          "name": option.info.tableName,
          // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf'),
          "pathArgs": { "opType": 'model', "opName": option.info.tableName },
        },
        "where": "id=${req.id} and tb_status=0",
        "fields": [
          {
            "name": "tb_status",
            "value": "0"
          },
          {
            "name": "tb_utime",
            "value": "new Date()"
          },
          {
            "name": "tb_uuserid",
            "value": "req.session.userId"
          }
        ],
        "statements": [
          {
            "category": "common",
            "type": "assign",
            "operator": "=",
            "varName": "res.id",
            "value": "req.id"
          }
        ]
      }
    }
    else if (option.other.type == "insert") {
      statements = {
        "category": "db",
        "type": "insert",
        "model": {
          "name": option.info.tableName,
          // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf'),
          "pathArgs": { "opType": 'model', "opName": option.info.tableName },
        },
        "fields": [
          {
            "name": "tb_status",
            "value": "0"
          },
          {
            "name": "tb_ctime",
            "value": "new Date()"
          },
          {
            "name": "tb_cuserid",
            "value": "req.session.userId"
          }
        ],
        "cbArg": "ret",
        "statements": [
          {
            "category": "common",
            "type": "assign",
            "varName": "res.id",
            "operator": "=",
            "value": "ret.insertId"
          }
        ]
      }
    }
    else {
      statements = null;
    }
  }
  else if (option.type == "get") {
    statements = {
      "category": "db",
      "type": "query",
      "model": {
        "name": option.info.tableName,
        // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf'),
        "pathArgs": { "opType": 'model', "opName": option.info.tableName },
      },
      "fields": [
        {
          "name": "id"
        },
        {
          "name": "tb_status"
        },
        {
          "name": "tb_ctime"
        },
        {
          "name": "tb_cuserid"
        },
        {
          "name": "tb_utime"
        },
        {
          "name": "tb_uuserid"
        },
        {
          "name": "tb_dtime"
        },
        {
          "name": "tb_duserid"
        },
        {
          "name": "tb_rid"
        },
        {
          "name": "tb_info"
        }
      ],
      "orders": [],
      "groups": [],
      "where": "",
      "pageSize": 20,
      "enableDataPage": false,
      "count": 1,
      "distinct": false,
      "queryArgs": [
        {
          "name": "id",
          "comment": "id",
          "condition": "id={req.id} and tb_status=0"
        }
      ],
      "cbArg": "rows",
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "varName": "res.data",
          "operator": "=",
          "value": "rows[0]"
        }
      ]
    }
  }
  else if (option.type == "list") {
    statements = {
      "category": "db",
      "type": "complexQuery",
      // "model": {
      //   "name": option.info.tableName,
      //   "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf')
      // },
      "model": {
        "name": "",
        "alias": "",
        "pathArgs": {},
      },
      "joins": [],
      "fields": [],
      "cbArg": "rows",
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "varName": "res.data",
          "operator": "=",
          "value": "rows"
        }
      ],
      "queryArgs": [
      ],
      "orders": [],
      "groups": [],
      "pageSize": 20,
      "enableDataPage": true,
      "count": null,
      "distinct": false,
      "where": ""
    }
  }
  else if (option.type == "remove") {
    statements = {
      "category": "db",
      "type": "update",
      "model": {
        "name": option.info.tableName,
        // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + '.tdf'),
        "pathArgs": { "opType": 'model', "opName": option.info.tableName },
      },
      "fields": [
        {
          "name": "tb_status",
          "value": "1"
        },
        {
          "name": "tb_dtime",
          "value": "new Date()"
        },
        {
          "name": "tb_duserid",
          "value": "req.session.userId"
        }
      ],
      "where": "id=${req.id}",
      "statements": [
      ]
    }
  }

  return statements;
};

/**
 * 默认TBS
 * @param {object} option 参数
 * @param {string} option.type 类型(save|get|list|remove)
 * @param {object} option.info 信息 tableName filePath
 * @returns 
 */
TdfManagerBl.prototype.defaultTBSSub = function (option) {
  var statements = {};

  if (option.type == "save") {
    if (option.other.type == "insert") {
      statements = {
        "category": "db",
        "type": "batchinsert",
        "model": {
          "name": option.info.tableName + "_" + option.other.subTableName,
          // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf'),
          "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
        },
        "dataListVar": "req." + option.other.subTableName,
        "fields": [
          {
            "name": "tb_rid",
            "value": "res.id"
          },
          {
            "name": "tb_status",
            "value": "0"
          },
          {
            "name": "tb_ctime",
            "value": "new Date()"
          },
          {
            "name": "tb_cuserid",
            "value": "req.session.userId"
          }
        ],
        "statements": []
      }
    }
    else if (option.other.type == "insertupdate") {
      statements = {
        "category": "db",
        "type": "update",
        "model": {
          "name": option.info.tableName + "_" + option.other.subTableName,
          // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf')
          "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
        },
        "where": "tb_rid=${req.id} and tb_status=0",
        "fields": [
          {
            "name": "tb_status",
            "value": "2"
          }
        ],
        "statements": [
          {
            "category": "db",
            "type": "batchinsertupdate",
            "model": {
              "name": option.info.tableName + "_" + option.other.subTableName,
              // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf')
              "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
            },
            "dataListVar": "req." + option.other.subTableName,
            "condition": "#{id}",
            "insertfields": [
              {
                "name": "tb_rid",
                "value": "res.id"
              },
              {
                "name": "tb_status",
                "value": "0"
              },
              {
                "name": "tb_ctime",
                "value": "new Date()"
              },
              {
                "name": "tb_cuserid",
                "value": "req.session.userId"
              }
            ],

            "updatewhere": "id=#{id}",
            "updatefields": [
              {
                "name": "tb_rid",
                "value": "res.id"
              },
              {
                "name": "tb_status",
                "value": "0"
              },
              {
                "name": "tb_utime",
                "value": "new Date()"
              },
              {
                "name": "tb_uuserid",
                "value": "req.session.userId"
              }
            ],
            "statements": []
          }
        ]
      };
      statements = {
        "category": "db",
        "type": "delete",
        "model": {
          "name": option.info.tableName + "_" + option.other.subTableName,
          // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf'),
          "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
        },
        "where": "tb_rid={req.id}",
        "statements": [{
          "category": "db",
          "type": "batchinsert",
          "model": {
            "name": option.info.tableName + "_" + option.other.subTableName,
            // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf'),
            "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
          },
          "dataListVar": "req." + option.other.subTableName,
          "fields": [
            {
              "name": "tb_rid",
              "value": "res.id"
            },
            {
              "name": "tb_status",
              "value": "0"
            },
            {
              "name": "tb_ctime",
              "value": "new Date()"
            },
            {
              "name": "tb_cuserid",
              "value": "req.session.userId"
            }
          ],
          "statements": []
        }]
      }
    }
    else {
      statements = null;
    }
  }
  else if (option.type == "get") {
    statements = {
      "category": "db",
      "type": "query",
      "model": {
        "name": option.info.tableName + "_" + option.other.subTableName,
        // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf')
        "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
      },
      "fields": [
        {
          "name": "id"
        },
        {
          "name": "tb_status"
        },
        {
          "name": "tb_ctime"
        },
        {
          "name": "tb_cuserid"
        },
        {
          "name": "tb_utime"
        },
        {
          "name": "tb_uuserid"
        },
        {
          "name": "tb_dtime"
        },
        {
          "name": "tb_duserid"
        },
        {
          "name": "tb_rid"
        },
        {
          "name": "tb_info"
        }
      ],
      "orders": [],
      "groups": [],
      "where": "",
      "pageSize": 20,
      "enableDataPage": false,
      "count": null,
      "distinct": false,
      "queryArgs": [
        {
          "name": "id",
          "comment": "tb_rid",
          "condition": "tb_rid={req.id} and tb_status=0"
        }
      ],
      "cbArg": "rows_" + option.other.subTableName,
      "statements": [
        {
          "category": "common",
          "type": "assign",
          "varName": "res.data_" + option.other.subTableName,
          "operator": "=",
          "value": "rows_" + option.other.subTableName
        }
      ]
    }

  }
  else if (option.type == "list") {
  }
  else if (option.type == "remove") {
    statements = {
      "category": "db",
      "type": "update",
      "model": {
        "name": option.info.tableName + "_" + option.other.subTableName,
        // "path": option.info.filePath.replace('.tdf', '.model.' + option.info.tableName + "_" + option.other.subTableName + '.tdf')
        "pathArgs": { "opType": 'model', "opName": option.info.tableName + "_" + option.other.subTableName },
      },
      "fields": [
        {
          "name": "tb_status",
          "value": "1"
        },
        {
          "name": "tb_dtime",
          "value": "new Date()"
        },
        {
          "name": "tb_duserid",
          "value": "req.session.userId"
        }
      ],
      "where": "tb_rid=${req.id} and tb_status=0",
      "statements": [
      ]
    }
  }

  return statements;
};

/**
 * 
 * @returns 
 */
TdfManagerBl.prototype.defaultTBSEnd = function () {
  return {
    "category": "common",
    "type": "end"
  }
};

/**
 * 默认TDM
 * @param {object} option 参数
 * @param {string} option.info 信息 projName tableName
 * @param {string} option.other 其他 subTableName
 * @returns 
 */
TdfManagerBl.prototype.defaultTDM = function (option) {
  var tdm = {
    "dbType": "mysql",
    "type": "table",
    "version": 1,
    "oldVersion": 0,
    "status": 0,
    "fields": {
      "id": {
        "dataType": "INT",
        "type": "int",
        "primaryKey": true,
        "autoIncrement": true,
        "notNull": true,
        "comment": "编号",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_status": {
        "dataType": "INT",
        "type": "int",
        "comment": "状态",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_ctime": {
        "dataType": "DATETIME",
        "type": "datetime",
        "comment": "创建时间",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_cuserid": {
        "dataType": "INT",
        "type": "int",
        "comment": "创建人",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_utime": {
        "dataType": "DATETIME",
        "type": "datetime",
        "comment": "修改时间",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_uuserid": {
        "dataType": "INT",
        "type": "int",
        "comment": "修改人",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_dtime": {
        "dataType": "DATETIME",
        "type": "datetime",
        "comment": "删除时间",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_duserid": {
        "dataType": "INT",
        "type": "int",
        "comment": "删除人",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_rid": {
        "dataType": "INT",
        "type": "int",
        "comment": "关联编号",
        "version": 1,
        "status": 0,
        "standard": true
      },
      "tb_info": {
        "dataType": "VARCHAR",
        "type": "string",
        "length": 200,
        "comment": "信息",
        "version": 1,
        "status": 0,
        "standard": true
      }
    },
    "indexs": [
      "id", "tb_status", "tb_ctime", "tb_cuserid", "tb_utime", "tb_uuserid", "tb_dtime", "tb_duserid", "tb_rid", "tb_info"
    ]
  };

  if (option.other && option.other.subTableName)
    tdm.table = option.info.projName + '_' + option.info.tableName + '_' + option.other.subTableName;
  else
    tdm.table = option.info.projName + '_' + option.info.tableName;

  return tdm;
};

/**
 * 默认元素
 * @param {object} option 参数
 * @returns 
 */
TdfManagerBl.prototype.defaultItems = function (option) {
  return {
    "main": [
      {
        "uid": uuid.v1().replace(/-/g, ''),
        "id": "name",
        "type": "Text",
        "title": "名称",
        "rowIndex": 1,
        "colWidth": 12,
        "attr": {},

        "requestType": "string",
        "requestNotNull": false,

        "fieldName": "name",
        "fieldType": "VARCHAR",
        "length": 200, //
        "precision": null, //
        "scale": null //
      },
      {
        "uid": uuid.v1().replace(/-/g, ''),
        "id": "code",
        "type": "Text",
        "title": "代码",
        "rowIndex": 1,
        "colWidth": 12,
        "attr": {},

        "requestType": "string",
        "requestNotNull": false,

        "fieldName": "code",
        "fieldType": "VARCHAR",
        "length": 200, //
        "precision": null, //
        "scale": null //
      }
    ]

    // "show": {
    //   "req": [{
    //     "whereName": "name",
    //     "whereType": "Text",
    //     "whereTitle": "名称",
    //     "whereIndex": 1,
    //     "whereAttr": {},

    //     "conditionType": "string",
    //     "conditionValue": "name like {%req.name%}",
    //   }],
    //   "res": [{
    //     "fieldFormat": "name",
    //     "fieldAlias": "名称",
    //     "fieldIndex": 1,
    //     "width":"",
    //     "align":""
    //   }]
    // }

  };
};

/**
 * 删除不涉及的前后台
 * @param {object} tdf 
 * @returns {object}
 */
TdfManagerBl.prototype.deleteNotInvolve = function (tdf) {
  const tfpList = ['edit', 'mEdit', 'index', 'mIndex'];
  const tbsList = ['save', 'get', 'remove'];
  const pcPages = tdf.tabs.pages || [];
  const phonePages = tdf.phoneTabs.pages || [];
  pcPages.forEach((page, index) => {
    tfpList.push(page.code || 'index' + index);
    tbsList.push(page.code || 'list' + index);
  });
  phonePages.forEach((page, index) => {
    tfpList.push(page.code || 'mList' + (index || ''));
    tbsList.push(page.code || 'mList' + index);
  });
  for (const tfpName in tdf.views) {
    !tfpList.includes(tfpName) && delete tdf.views[tfpName];
  }
  for (const tbsName in tdf.services) {
    !tbsList.includes(tbsName) && delete tdf.services[tbsName];
  }
  return tdf;
}

// TdfManagerBl.prototype.defaultItemsSub = function (option) {
//   return {
//     "sub_": [
//       {
//         "uid": uuid.v1().replace(/-/g, ''),
//         "id": "name",
//         "type": "Text",
//         "title": "名称",
//         "rowIndex": 1,
//         "colWidth": 12,
//         "attr": {},

//         "requestType": "string",
//         "requestNotNull": false,

//         "fieldName": "name",
//         "fieldType": "VARCHAR",
//         "length": 200, //
//         "precision": null, //
//         "scale": null //
//       }
//     ]
//   }
// }




// {
//   json.id = "page1";
//   json.type = "Page";
//   json.components = [
//     {
//       "type": "Form",
//       "id": "form1",
//       "components": [
//         {
//           "type": "Gridbox",
//           "id": "gridbox1",
//           "components": [
//             {
//               "type": "Panel",
//               "id": "panelTitle",
//               "styles": {
//                 "width": "100%",
//                 "padding": "0px 4px"
//               },
//               "components": [
//                 {
//                   "type": "Label",
//                   "id": "labelTitle",
//                   "value": json.title,
//                   "size": "title4"
//                 }
//               ]
//             },
//             {
//               "type": "Row",
//               "id": "row1",
//               "components": [
//                 {
//                   "type": "Col",
//                   "id": "col1",
//                   "colWidth": 24,
//                   "components": [
//                     {
//                       "type": "Cellbox",
//                       "id": "cellbox1",
//                       "components": [
//                         {
//                           "id": "cellbox1_cellitem1",
//                           "type": "Cellitem",
//                           "components": [
//                             {
//                               "id": "label1",
//                               "type": "Label",
//                               "value": "名称："
//                             }
//                           ],
//                           "colWidth": ""
//                         },
//                         {
//                           "id": "cellbox1_cellitem2",
//                           "type": "Cellitem",
//                           "components": [
//                             {
//                               "id": "name",
//                               "type": "Text",
//                               "styles": {
//                                 "width": "100%",
//                                 "height": "30px",
//                                 "line-height": "30px",
//                                 "padding-left": "2px",
//                                 "padding-right": "2px"
//                               },
//                               "dataType": "text"
//                             }
//                           ],
//                           "colWidth": "main"
//                         }
//                       ],
//                       "direction": "column"
//                     }
//                   ]
//                 }
//               ]
//             }
//           ]
//         }
//       ]
//     },
//     {
//       "type": "Service",
//       "id": "serviceGet",
//       "autoShowError": true
//     },
//     {
//       "type": "Service",
//       "id": "serviceSave",
//       "autoShowError": true
//     }
//   ];
// }

/**
 * 获取数据表单中tdf页面地址
 * @param {String} projName 项目名称
 * @param {String} dataName 数据表单名称
 * @param {String} pageName 页面名称
 * @returns {String} 页面地址
 */
TdfManagerBl.prototype.getTdfViewPath = function (info, pageName, param) {
  return `/app/${info.projName}/tdf/${info.dataPath ? (info.dataPath + '/') : ''}${info.dataName}.view.${pageName}.tdf${param || ''}`;
};